/* -*- C++ -*-
 * src/test/graph_test.h - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */
#ifndef LEMON_TEST_GRAPH_TEST_H
#define LEMON_TEST_GRAPH_TEST_H


#include "test_tools.h"

//! \ingroup misc
//! \file
//! \brief Some utility to  test graph classes.
namespace lemon {

  template<class Graph> void checkGraphNodeList(Graph &G, int nn)
    {
      typename Graph::NodeIt n(G);
      for(int i=0;i<nn;i++) {
	check(n!=INVALID,"Wrong Node list linking.");
	++n;
      }
      check(n==INVALID,"Wrong Node list linking.");
    }

  template<class Graph> void checkGraphEdgeList(Graph &G, int nn)
    {
      typedef typename Graph::EdgeIt EdgeIt;

      EdgeIt e(G);
      for(int i=0;i<nn;i++) {
	check(e!=INVALID,"Wrong Edge list linking.");
	++e;
      }
      check(e==INVALID,"Wrong Edge list linking.");
    }

  template<class Graph> void checkGraphOutEdgeList(Graph &G,
						   typename Graph::Node n,
						   int nn)
    {
      typename Graph::OutEdgeIt e(G,n);
      for(int i=0;i<nn;i++) {
	check(e!=INVALID,"Wrong OutEdge list linking.");
	check(n==G.tail(e), "Wrong OutEdge list linking.");
	++e;
      }
      check(e==INVALID,"Wrong OutEdge list linking.");
    }

  template<class Graph> void checkGraphInEdgeList(Graph &G,
						  typename Graph::Node n,
						  int nn)
    {
      typename Graph::InEdgeIt e(G,n);
      for(int i=0;i<nn;i++) {
	check(e!=INVALID,"Wrong InEdge list linking.");
	check(n==G.head(e), "Wrong InEdge list linking.");
	++e;
      }
      check(e==INVALID,"Wrong InEdge list linking.");
    }

  ///\file
  ///\todo Check head(), tail() as well;

  
} //namespace lemon


#endif
