#include"lp_solver_skeleton.h"

using namespace lemon;

int main()
{
  typedef LpSolverSkeleton LP;
  LP lp;

  std::vector<LP::Col> x;
  for(int i=0;i<10;i++) x.push_back(lp.addCol());

  std::vector<LP::Col> y(10);
  lp.addColSet(y);

  std::map<int,LP::Col> z;
  
  z.insert(std::make_pair(12,INVALID));
  z.insert(std::make_pair(2,INVALID));
  z.insert(std::make_pair(7,INVALID));
  z.insert(std::make_pair(5,INVALID));
  
  lp.addColSet(z);


  LP::Expr e;
  e[x[3]]=2;
  e[x[3]]=4;
  e[x[3]]=1;
  e.constComp()=12;
  lp.addRow(LP::INF,e,23);

}
