// -*- mode:C++ -*-

#include<math.h>
#include<hugo/list_graph.h>
#include<hugo/smart_graph.h>
#include<hugo/dijkstra.h>
#include<hugo/max_flow.h>

#include"bench_tools.h"

using namespace std;
using namespace hugo;

template<class Graph>
void addHiperCube(Graph &G,int dim,vector<typename Graph::Node> &nodes)
{
  GRAPH_TYPEDEF_FACTORY(Graph);
  
  vector<int> bits(dim+1);
  bits[0]=1;
  for(int i=1;i<=dim;i++) bits[i]=2*bits[i-1];
  
  for(int i=0;i<bits[dim];i++) {
    nodes.push_back(G.addNode());
    for(int j=0;j<dim;j++) if(i&bits[j]) G.addEdge(nodes[i-bits[j]],nodes[i]);
  }
}

template<class Graph>
void addBiDirHiperCube(Graph &G,int dim,vector<typename Graph::Node> &nodes)
{
  GRAPH_TYPEDEF_FACTORY(Graph);
  
  vector<int> bits(dim+1);
  bits[0]=1;
  for(int i=1;i<=dim;i++) bits[i]=2*bits[i-1];
  
  for(int i=0;i<bits[dim];i++) {
    nodes.push_back(G.addNode());
    for(int j=0;j<dim;j++) if(i&bits[j]) {
      G.addEdge(nodes[i-bits[j]],nodes[i]);
      G.addEdge(nodes[i],nodes[i-bits[j]]);
    }
    
  }
}

inline int numOfOnes(int n,int dim)
{
  int s=0;
  for(int i=0;i<dim;i++) {
    s+=n%2;
    n>>=1;
  }
  return s;
}

inline int numOfZeros(int n,int dim)
{
  int s=dim;
  for(int i=0;i<dim;i++) {
    s-=n&1;
    n>>=1;
  }
  return s;
}

int main(int argc, char *argv[])
{
  //  typedef ListGraph Graph;
  typedef SmartGraph Graph;

  ///\bug GRAPH_TYPEDEF_FACTORY(Graph);
  GRAPH_TYPEDEF_FACTORY_NOTYPENAME(Graph);

  Graph G;
  
  Timer T;
  
  if(argc!=2) {
    cout << "Usage: " << argv[0] << " dim\n";
    return 1;
  }
  
  int dim=atoi(argv[1]);
  
//   cout << "Creating Hipercube ("<< (1<<dim) << " nodes, "
//        << dim*(1<<dim) << " edges):";

  T.reset();
  vector<Node> nodes;
  addBiDirHiperCube(G,dim,nodes);

  PrintTime("GENGRAPH",T);

  T.reset();
  Graph::EdgeMap<int> map(G);
  for(int i=0;i<5;i++) {
    Primes P;
    for(int i=0;i<dim*(1<<dim);i++) P();
    
    //  for(EdgeIt e(G);G.valid(e);G.next(e)) map[e]=P();
    for(int i=0;i<dim*(1<<dim);i++)
      //    map[Edge(((long long int)(i)*2987)%(dim*(1<<dim)))]=P();
      map[Edge(((long long int)(i)*93505)%(dim*(1<<dim)))]=P();
  
//     for(int i=0;i<(1<<dim);i++) {
//       int mul= (1<<(numOfZeros(i,dim)/4));
//       for(OutEdgeIt e(G,nodes[i]);G.valid(e);G.next(e))
// 	map[e]*=mul;
//     }
  }
  
  PrintTime("GENLENGTHS",T);

  T.reset();
  {
    Dijkstra<Graph> Dij(G,map);
    for(int i=0;i<10;i++)
      Dij.run(nodes[0]);
  }
  PrintTime("DIJKSTRA",T);

  T.reset();
  {
   Graph::EdgeMap<int> flow(G);
   
    MaxFlow<Graph,int> MF(G,nodes[0],nodes[1<<dim-1],map,flow);
    for(int i=0;i<10;i++)
      MF.run(MF.NO_FLOW);
  }
  PrintTime("PREFLOW",T);

}
