#include<iostream>
#include<hugo/smart_graph.h>
#include<hugo/skeletons/graph.h>
#include<hugo/list_graph.h>
#include<hugo/full_graph.h>
#include<hugo/graph_wrapper.h>

#include"test/test_tools.h"
#include"test/graph_test.h"

/**
\file
This test makes consistency checks of graph wrappers.

\todo More extensive tests are needed 
*/

using namespace hugo;


typedef SmartGraph Graph;

//Compile GraphWrapper
typedef GraphWrapper<Graph> GW;
template void checkCompileStaticGraph<GW>(GW &);

//Compile RevGraphWrapper
typedef RevGraphWrapper<Graph> RevGW;
template void checkCompileStaticGraph<RevGW>(RevGW &);

//Compile SubGraphWrapper
typedef SubGraphWrapper<Graph, Graph::NodeMap<bool>, 
			Graph::EdgeMap<bool> > SubGW;
template void checkCompileStaticGraph<SubGW>(SubGW &);

//Compile UndirGraphWrapper
/// \bug UndirGraphWrapper cannot pass the StaticGraph test
//typedef UndirGraphWrapper<Graph> UndirGW;
//template void checkCompileStaticGraph<UndirGW>(UndirGW &);

//Compile UndirGraph
//typedef UndirGraph<Graph> UndirG;
//template void checkCompileStaticGraph<UndirG>(UndirG &);

//typedef SubBidirGraphWrapper<Graph, Graph::EdgeMap<bool>, 
/// \bug SubBidirGraphWrapper cannot pass the StaticGraph test
//			     Graph::EdgeMap<bool> > SubBDGW;
//template void checkCompileStaticGraph<SubBDGW>(SubBDGW &);

//Compile BidirGraphWrapper
//typedef BidirGraphWrapper<Graph> BidirGW;
//template void checkCompileStaticGraph<BidirGW>(BidirGW &);

//Compile BidirGraph
//typedef BidirGraph<Graph> BidirG;
//template void checkCompileStaticGraph<BidirG>(BidirG &);

//Compile ResGraphWrapper
//typedef ResGraphWrapper<Graph, int, Graph::EdgeMap<int>, 
//			Graph::EdgeMap<int> > ResGW;
//template void checkCompileStaticGraph<ResGW>(ResGW &);

//Compile ErasingFirstGraphWrapper
typedef ErasingFirstGraphWrapper<Graph, Graph::NodeMap<Graph::Edge> > ErasingFirstGW;
template void checkCompileStaticGraph<ErasingFirstGW>(ErasingFirstGW &);


int main() 
{
  std::cout << __FILE__ ": All tests passed.\n";

  return 0;
}
