#include <iostream>

#include <hugo/list_graph.h>
#include <hugo/dimacs.h>
#include <max_flow.h>
#include <max_flow_no_stack.h>
#include <hugo/time_measure.h>

using namespace hugo;

int main(int, char **) {
 
  typedef ListGraph Graph;
  
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;

  Graph G;
  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacs(std::cin, G, cap, s, t);
  Timer ts;
  
  std::cout <<
    "\n  Running max_flow.h on a graph with " << 
    G.nodeNum() << " nodes and " << G.edgeNum() << " edges..."
	   << std::endl<<std::endl;

  Graph::EdgeMap<int> flowstack(G,0);
  MaxFlow<Graph, int> max_flow_test(G, s, t, cap, flowstack);
  ts.reset();
  max_flow_test.run();
  std::cout << "Elapsed time of run() with stl stack: " << std::endl 
	    <<ts << std::endl;

  Graph::EdgeMap<int> flow(G,0);
  MaxFlowNoStack<Graph, int> max_flow_test_no_stack(G, s, t, cap, flow);
  ts.reset();
  max_flow_test_no_stack.run();
  std::cout << "Elapsed time of run() without stack: " << std::endl 
	    <<ts << std::endl;
  
  Graph::NodeMap<bool> mincut(G);
  max_flow_test_no_stack.minMinCut(mincut); 
  int min_min_cut_value=0;
  EdgeIt e;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (mincut[G.tail(e)] && !mincut[G.head(e)]) min_min_cut_value+=cap[e];
  }

  Graph::NodeMap<bool> cut(G);
  max_flow_test_no_stack.minCut(cut); 
  int min_cut_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut[G.tail(e)] && !cut[G.head(e)]) 
      min_cut_value+=cap[e];
  }

  Graph::NodeMap<bool> maxcut(G);
  max_flow_test_no_stack.maxMinCut(maxcut); 
  int max_min_cut_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (maxcut[G.tail(e)] && !maxcut[G.head(e)]) 
      max_min_cut_value+=cap[e];
      }

  std::cout << "\n Checking the result without stack: " <<std::endl;  
  std::cout << "Flow value: "<< max_flow_test_no_stack.flowValue() << std::endl;
  std::cout << "Min cut value: "<< min_cut_value << std::endl;
  std::cout << "Min min cut value: "<< min_min_cut_value << std::endl;
  std::cout << "Max min cut value: "<< max_min_cut_value << 
    std::endl;

  if ( max_flow_test_no_stack.flowValue() == min_cut_value &&
       min_cut_value == min_min_cut_value &&
       min_min_cut_value == max_min_cut_value )
    std::cout << "They are equal! " <<std::endl<< std::endl<<"\n";  

  /*

  Graph::EdgeMap<int> flow2(G,0);
  std::cout << "Calling resetFlow() " << std::endl 
	    << ts << std::endl;
  max_flow_test.setFlow(flow2);  
  ts.reset();
  max_flow_test.preflow(max_flow_test.PRE_FLOW);
  std::cout << "Elapsed time of preflow(PRE_FLOW) starting from the zero flow: " << std::endl 
	    << ts << std::endl;
  
  Graph::NodeMap<bool> mincut2(G);
  max_flow_test.minMinCut(mincut2); 
  int min_min_cut_value2=0;
    for(G.first(e); G.valid(e); G.next(e)) {
    if (mincut2[G.tail(e)] && !mincut2[G.head(e)]) min_min_cut_value2+=cap[e];
  }

  Graph::NodeMap<bool> cut2(G);
  max_flow_test.minCut(cut2); 
  int min_cut_value2=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut2[G.tail(e)] && !cut2[G.head(e)]) 
      min_cut_value2+=cap[e];
  }

  Graph::NodeMap<bool> maxcut2(G);
  max_flow_test.maxMinCut(maxcut2); 
  int max_min_cut_value2=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (maxcut2[G.tail(e)] && !maxcut2[G.head(e)]) 
      max_min_cut_value2+=cap[e];
      }
  
  std::cout << "\n Checking the result: " <<std::endl;  
  std::cout << "Flow value: "<< max_flow_test.flowValue() << std::endl;
  std::cout << "Min cut value: "<< min_cut_value2 << std::endl;
  std::cout << "Min min cut value: "<< min_min_cut_value2 << std::endl;
  std::cout << "Max min cut value: "<< max_min_cut_value2 << 
    std::endl;  
  if ( max_flow_test.flowValue() == min_cut_value &&
       min_cut_value == min_min_cut_value &&
       min_min_cut_value == max_min_cut_value )
    std::cout << "They are equal! " <<std::endl;  


  MaxFlow<Graph, int> max_flow_test3(G, s, t, cap, flow2);
  max_flow_test3.run(max_flow_test3.GEN_FLOW);
  std::cout << "Calling run(GEN_FLOW) from the max flow found before. " <<std::endl;  
  
  Graph::NodeMap<bool> mincut3(G);
  max_flow_test3.minMinCut(mincut3); 
  int min_min_cut_value3=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (mincut3[G.tail(e)] && !mincut3[G.head(e)]) min_min_cut_value3+=cap[e];
  }

  Graph::NodeMap<bool> cut3(G);
  max_flow_test3.minCut(cut3); 
  int min_cut_value3=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut3[G.tail(e)] && !cut3[G.head(e)]) 
      min_cut_value3+=cap[e];
  }

  Graph::NodeMap<bool> maxcut3(G);
  max_flow_test3.maxMinCut(maxcut3); 
  int max_min_cut_value3=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (maxcut3[G.tail(e)] && !maxcut3[G.head(e)]) 
      max_min_cut_value3+=cap[e];
  }

  std::cout << "\n Checking the result: " <<std::endl;  
  std::cout << "Flow value: "<< max_flow_test3.flowValue() << std::endl;
  std::cout << "Min cut value: "<< min_cut_value3 << std::endl;
  std::cout << "Min min cut value: "<< min_min_cut_value3 << std::endl;
  std::cout << "Max min cut value: "<< max_min_cut_value3 << 
    std::endl;

  if ( max_flow_test3.flowValue() == min_cut_value3 &&
       min_cut_value3 == min_min_cut_value3 &&
       min_min_cut_value3 == max_min_cut_value3 )
    std::cout << "They are equal! " <<std::endl<< std::endl<<"\n";  
  */
  
  return 0;
}
