#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <dijkstra.h>
#include <time_measure.h>

using namespace hugo;

int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "dijkstra demo ..." << std::endl;
  
  double pre_time=currTime();
    Dijkstra<ListGraph, int> dijkstra_test(G, s, cap);
    dijkstra_test.run();
  double post_time=currTime();
    
  std::cout << "running time: " << post_time-pre_time << " sec"<< std::endl; 
 
  int hiba=0;
  EachEdgeIt e;
  for ( G.getFirst(e) ; G.valid(e); G.next(e) ) {
    NodeIt u=G.tail(e);
    NodeIt v=G.head(e);
    if ( dijkstra_test.dist(v) - dijkstra_test.dist(u) > cap.get(e) ) {
      std::cout<<"Hiba: "<<dijkstra_test.dist(v) - dijkstra_test.dist(u) - cap.get(e)<<std::endl;
      ++hiba;
    }
  }

  std::cout << "Hibas elek szama: " << hiba << " a " << G.edgeNum() <<"-bol."<< std::endl;

  return 0;
}
