#include <iostream>
#include <fstream>

#include <LEDA/graph.h>
#include <LEDA/graph_alg.h>
#include <LEDA/dimacs.h>

#if defined(LEDA_NAMESPACE)
using namespace leda;
#endif

using namespace std;

#include <time_measure.h>

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo_leda < dimacs_max_flow_file
int main() 
{
  GRAPH<int,int> G;
  leda_node s,t;
  leda_edge_array<int> cap;
  Read_Dimacs_MF(cin,G,s,t,cap);
 
  leda_edge_array<int> flow(G);

  std::cout << "preflow demo (LEDA)..." << std::endl;
  double pre_time=currTime();
  int flow_value = MAX_FLOW(G,s,t,cap,flow); 
  double post_time=currTime();
  //std::cout << "maximum flow: "<< std::endl;
  //std::cout<<std::endl;
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< flow_value << std::endl;

  return 0;
}
