#include <iostream>
#include <fstream>

#include <smart_graph.h>
#include <list_graph.h>
#include <dimacs.h>
#include <preflow.h>
#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef SmartGraph::Node Node;
  typedef SmartGraph::EdgeIt EdgeIt;

  SmartGraph G;
  Node s, t;
  SmartGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "preflow demo ..." << std::endl;
  
  double mintime=1000000;

  for ( int i=1; i!=11; ++i ) {
    SmartGraph::EdgeMap<int> flow(G);
    double pre_time=currTime();
    Preflow<SmartGraph, int> max_flow_test(G, s, t, cap, flow);
    max_flow_test.run();
    double post_time=currTime();
    if ( mintime > post_time-pre_time ) mintime = post_time-pre_time;
  }

  SmartGraph::EdgeMap<int> flow(G);
  Preflow<SmartGraph, int> max_flow_test(G, s, t, cap, flow);
  max_flow_test.run();
  
  SmartGraph::NodeMap<bool> cut(G);
  max_flow_test.minCut(cut); 
  int min_cut_value=0;
  EdgeIt e;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut[G.tail(e)] && !cut[G.head(e)]) min_cut_value+=cap[e];
  }

  SmartGraph::NodeMap<bool> cut1(G);
  max_flow_test.minMinCut(cut1); 
  int min_min_cut_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut[G.tail(e)] && !cut[G.head(e)]) 
      min_min_cut_value+=cap[e];
  }

  SmartGraph::NodeMap<bool> cut2(G);
  max_flow_test.maxMinCut(cut2); 
  int max_min_cut_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut2[G.tail(e)] && !cut2[G.head(e)]) 
      max_min_cut_value+=cap[e];
      }
  
  std::cout << "min time of 10 runs: " << mintime << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  std::cout << "min cut value: "<< min_cut_value << std::endl;
  std::cout << "min min cut value: "<< min_min_cut_value << std::endl;
  std::cout << "max min cut value: "<< max_min_cut_value << 
    std::endl<< std::endl;
  
  return 0;
}
