#include <string>
#include <iostream>
#include <stdio.h>

#include "edgepathgraph.h"
#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <path.h>

using namespace lemon;
using namespace std;

bool passed = true;

void check(bool rc) {
  passed = passed && rc;
  if(!rc) {
    cout << "Test failed!" << endl;
  }
}

int main()
{
  {
      EdgePathGraph<DirPath<ListGraph>, SmartGraph, ListGraph> EPGr;
      EPGr.addNode();
      EPGr.addNode();
      EPGr.addNode();
      EPGr.addNode();
      printf("%d node is in EPGr, after addition of 4 nodes.\n", EPGr.nodeNum());

      EdgePathGraph<DirPath<ListGraph>, SmartGraph, ListGraph> EPGr2(EPGr);
      printf("%d node is in EPGr2 created by copy constructor from EPGr.\n", EPGr2.nodeNum());

      EPGr2.addNode();
      EPGr2.addNode();
      printf("%d node is in EPGr2 after addition of 2 more nodes.\n", EPGr2.nodeNum());

      printf("%d nodes are in EPGr, before clear.\n", EPGr.nodeNum());
      EPGr.clear();
      printf("%d nodes are in EPGr, after clear.\n", EPGr.nodeNum());
      printf("%d nodes are in EPGr2, after clear of EPGr.\n", EPGr2.nodeNum());
      EPGr2.clear();
  }
  {
      EdgePathGraph<DirPath<ListGraph>, SmartGraph, ListGraph> EPGr;
      //EdgePathGraph<DirPath<ListGraph>, SmartGraph, EdgePathGraph<DirPath<SmartGraph>, ListGraph, SmartGraph> > EPGr;
      EdgePathGraph<DirPath<SmartGraph>, ListGraph, SmartGraph> EPGr2;
   
      typedef EdgePathGraph<DirPath<SmartGraph>, SmartGraph, ListGraph>::Node Node;
      typedef EdgePathGraph<DirPath<SmartGraph>, SmartGraph, ListGraph>::Edge Edge;
      typedef EdgePathGraph<DirPath<SmartGraph>, SmartGraph, ListGraph>::EdgeIt EdgeIt;

      Node n0, n1, n2;
      Edge e0, e1, e2, e3, e4, e5;

      ListGraph::Node m0, m1, m2, m3;
      ListGraph::Edge f0, f1, f2, f3, f4, f5;


      n0=EPGr.addNode();
      n1=EPGr.addNode();
      n2=EPGr.addNode();

      e0=EPGr.addEdge(n0,n1);
      e1=EPGr.addEdge(n1,n0);
      e2=EPGr.addEdge(n0,n2);
      e3=EPGr.addEdge(n2,n0);
      e4=EPGr.addEdge(n1,n2);
      e5=EPGr.addEdge(n2,n1);


      m0=EPGr2.addNode();
      m1=EPGr2.addNode();
      m2=EPGr2.addNode();
      m3=EPGr2.addNode();
    
      f0=EPGr2.addEdge(m0,m3);
      f1=EPGr2.addEdge(m3,m0);
      f2=EPGr2.addEdge(m2,m3);
      f3=EPGr2.addEdge(m3,m2);
      f4=EPGr2.addEdge(m1,m2);
      f5=EPGr2.addEdge(m2,m1);

      EPGr.sublayer=&(EPGr2.actuallayer);
      //EPGr.sublayer=&(EPGr2);
    
      EPGr.projection[n0]=&m0;
      EPGr.projection[n1]=&m1;
      EPGr.projection[n2]=&m2;

      
      typedef DirPath<ListGraph> DPath;

      //DPath P(EPGr2);

      DPath P1(EPGr2.actuallayer);//0-2
      DPath::Builder B1(P1);
      B1.pushBack(f0);
      B1.pushBack(f3);
      B1.commit();
      cout << P1.length() << " hosszu utvonal letrehozva" << endl;

      DPath P2(EPGr2.actuallayer);//2-0
      DPath::Builder B2(P2);
      B2.pushBack(f2);
      B2.pushBack(f1);
      B2.commit();
      cout << P2.length() << " hosszu utvonal letrehozva" << endl;

      DPath P3(EPGr2.actuallayer);//0-1
      DPath::Builder B3(P3);
      B3.pushBack(f0);
      B3.pushBack(f3);
      B3.pushBack(f5);
      B3.commit();
      cout << P3.length() << " hosszu utvonal letrehozva" << endl;

      DPath P4(EPGr2.actuallayer);//1-0
      DPath::Builder B4(P4);
      B4.pushBack(f4);
      B4.pushBack(f2);
      B4.pushBack(f1);
      B4.commit();
      cout << P4.length() << " hosszu utvonal letrehozva" << endl;


      EPGr.edgepath[e0]=&P3;
      EPGr.edgepath[e1]=&P4;
      EPGr.edgepath[e2]=&P1;
      EPGr.edgepath[e3]=&P2;

      for(EdgeIt e(EPGr.actuallayer);EPGr.actuallayer.valid(e);EPGr.actuallayer.next(e))
      {
	typedef DPath::EdgeIt PEdgeIt;
	PEdgeIt f;

	cout << "Edge " << EPGr.id(EPGr.tail(e)) << " - " << EPGr.id(EPGr.head(e)) << " in actual layer is";
        if(EPGr.edgepath[e])
	{
	  cout << endl << "Path";
	  for(EPGr.edgepath[e]->first(f); EPGr.edgepath[e]->valid(f); EPGr.edgepath[e]->next(f))
	  {
	    cout << " " << EPGr2.id(EPGr2.tail(f)) << "-" << EPGr2.id(EPGr2.head(f));
	  }
	  //cout << EPGr2.id(EPGr2.head(f)) << endl;
	  cout << endl;
	}
	else
	{
	  cout << " itself." <<endl;
	}
      }
    

      cout << "================================" << endl;
    
      SmartGraph::EdgeMap<int> actlaymap(EPGr.actuallayer);
      //EdgePathGraph<DirPath<ListGraph>, SmartGraph, EdgePathGraph<DirPath<SmartGraph>, ListGraph, SmartGraph> > EPGr;
      ListGraph::EdgeMap<double> sublaymap(EPGr2.actuallayer);
      

      actlaymap[e1]=5;

      //EdgeMap-ok kiirasa

      cout << "EdgeMaps before addMap:" << endl;
    
      cout << "actlaymap: ";
      for(EdgeIt e(EPGr.actuallayer);EPGr.actuallayer.valid(e);EPGr.actuallayer.next(e))
      {
	cout << EPGr.id(EPGr.tail(e)) << "-" << EPGr.id(EPGr.head(e)) << ":" << actlaymap[e] << " ";
      }
      cout << endl;
      cout << "sublaymap: ";
      for(ListGraph::EdgeIt e(EPGr2.actuallayer);EPGr2.actuallayer.valid(e);EPGr2.actuallayer.next(e))
      {
	cout << EPGr2.id(EPGr2.tail(e)) << "-" << EPGr2.id(EPGr2.head(e)) << ":" << sublaymap[e] << " ";
      }
      cout << endl;
      //EdgeMap-ok kiirasa#vege

      
      EPGr.addMap<int, double>(actlaymap, sublaymap);

      //EdgeMap-ok kiirasa

      cout << "EdgeMaps after addMap:" << endl;
    
      cout << "actlaymap: ";
      for(EdgeIt e(EPGr.actuallayer);EPGr.actuallayer.valid(e);EPGr.actuallayer.next(e))
      {
	cout << EPGr.id(EPGr.tail(e)) << "-" << EPGr.id(EPGr.head(e)) << ":" << actlaymap[e] << " ";
      }
      cout << endl;
      cout << "sublaymap: ";
      for(ListGraph::EdgeIt e(EPGr2.actuallayer);EPGr2.actuallayer.valid(e);EPGr2.actuallayer.next(e))
      {
	cout << EPGr2.id(EPGr2.tail(e)) << "-" << EPGr2.id(EPGr2.head(e)) << ":" << sublaymap[e] << " ";
      }
      cout << endl;
      //EdgeMap-ok kiirasa#vege
    
    
  }
}
