#include <string>
#include <iostream>
#include <stdio.h>

#include "hierarchygraph.h"
#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <path.h>

using namespace lemon;
using namespace std;

bool passed = true;

void check(bool rc) {
  passed = passed && rc;
  if(!rc) {
    cout << "Test failed!" << endl;
  }
}

int main()
{
  HierarchyGraph<SmartGraph, ListGraph> HGr;
  ListGraph subnetwork, othernetwork;
  typedef HierarchyGraph<SmartGraph, ListGraph>::Node Node;
  typedef HierarchyGraph<SmartGraph, ListGraph>::Edge Edge;
  typedef HierarchyGraph<SmartGraph, ListGraph>::SubNetwork Sntype;

  Node n0, n1, n2;
  Edge e0, e1, e2, e3, e4, e5;

  ListGraph::Node sn0, sn1, on0;
  ListGraph::Edge se0;

  n0=HGr.addNode();

  cout << "Az n0 id-je: " << HGr.actuallayer.id(n0) << endl;

  n1=HGr.addNode();
  n2=HGr.addNode();
  
  e0=HGr.addEdge(n0,n1);
  e1=HGr.addEdge(n1,n0);
  e2=HGr.addEdge(n0,n2);
  e3=HGr.addEdge(n2,n0);
  e4=HGr.addEdge(n1,n2);
  e5=HGr.addEdge(n2,n1);

  sn0=subnetwork.addNode();
  sn1=subnetwork.addNode();
  se0=subnetwork.addEdge(sn0,sn1);

  Sntype sn;
  sn.setActualLayer(&(HGr.actuallayer));
  sn.setActualLayerNode(&(n0));
  sn.addAssignment(e0, sn0);
  sn.addAssignment(e1, sn1);
  sn.addAssignment(e2, sn1);
  sn.addAssignment(e3, sn0);
  sn.addAssignment(e1, sn0);
  sn.addAssignment(e5, sn0);
  


  on0=othernetwork.addNode();

  cout << "ID of a node from a different graph: " << subnetwork.id(on0) << endl;
  cout << "ID of a node in its graph: " << othernetwork.id(on0) << endl;
  cout << "ID of a node from a  graph: " << subnetwork.id(sn0) << endl;

  ListGraph::NodeIt snni;
  //ListGraph::Node snn;

  for(subnetwork.first(snni);subnetwork.valid(snni);subnetwork.next(snni))
  {
    if(snni==on0)
    {
      cout << "Nem jo, megtalalta az idegen node-ot sajat haloban, pedig azt nem szabad!!!" 
	   << subnetwork.id(snni) << subnetwork.id(on0) << othernetwork.id(snni) << othernetwork.id(on0) << endl;
    }
    else cout << "ID:" << subnetwork.id(snni) << endl;
      
  }
  

  HGr.subnetworks[n0]=sn;
  
}
