#include <string>
#include <iostream>
//#include <path.h>
#include <path_skeleton.h>
#include <list_graph.h>

using namespace std;
using namespace lemon;
using namespace skeleton;

bool passed = true;

void check(bool rc) {
  passed = passed && rc;
  if(!rc) {
    cout << "Test failed!" << endl;
  }
}

#ifdef DEBUG
const bool debug = true;
#else
const bool debug = false;
#endif


int main() {

  try {

    typedef ListGraph::Node Node;
    typedef ListGraph::Edge Edge;

    ListGraph G;

    Node s=G.addNode();
    Node v1=G.addNode();
    Node v2=G.addNode();
    Node v3=G.addNode();
    Node v4=G.addNode();
    Node t=G.addNode();
  
    Edge e1 = G.addEdge(s, v1);
    Edge e2 = G.addEdge(s, v2);
    Edge e3 = G.addEdge(v1, v2);
    Edge e4 = G.addEdge(v2, v1);
    Edge e5 = G.addEdge(v1, v3);
    Edge e6 = G.addEdge(v3, v2);
    Edge e7 = G.addEdge(v2, v4);
    Edge e8 = G.addEdge(v4, v3);
    Edge e9 = G.addEdge(v3, t);
    Edge e10 = G.addEdge(v4, t);

    bool rc;

    {
      cout << "\n\n\nDirPath tesztelese...\n";


      cout << "Ures path letrehozasa" << endl;
      //typedef DirPath<ListGraph> DPath;
      typedef Path <ListGraph> DPath;
      DPath P(G);

      cout << "P.length() == " << P.length() << endl;
      check(P.length() == 0);

#ifdef SKELETON
      cout << "P.tail() valid? " << (P.tail()!=INVALID) << endl;
      check(! (P.tail()!=INVALID));
#else
      cout << "P.tail() valid? " << (P.from()!=INVALID) << endl;
      check(! (P.to()!=INVALID));
#endif
      {
	cout << "Builder objektum letrehozasa" << endl;
	DPath::Builder B(P);

	cout << "Hozzaadunk az elejehez ket elet..." << endl;
	B.pushFront(e6);
	B.pushFront(e5);
	cout << "P.length() == " << P.length() << endl;
	check(P.length() == 0);
      
	cout << "Commitolunk..." << endl;
	B.commit();

	cout << "P.length() == " << P.length() << endl;
	check(P.length() == 2);

#ifdef SKELETON
	cout << "P.tail() valid? " << (P.tail()!=INVALID) << endl;
	check(P.tail()!=INVALID);
	cout << "P.tail()==v1 ? " << (P.tail()==v1) << endl;
	check(P.tail() == v1);
#else
	cout << "P.tail() valid? " << (P.from()!=INVALID) << endl;
	check(P.from()!=INVALID);
	cout << "P.tail()==v1 ? " << (P.from()==v1) << endl;
	check(P.from() == v1);
#endif

	// Na ja, ez igy nem igazi, mindket esetet le kene tesztelni,
	// de legalabb valami:
#ifdef DEBUG
	cout << "Hozzaadunk az elejehez egy nem illeszkedo elet..." << endl;
	rc = false;
	try {
	  B.pushFront(e3);
	}
	catch(const Exception &e) {
	  cout << "E: " << e.what() << endl;
	  rc = true;
	}
	check(rc);
#endif

	cout << "Hozzaadunk a vegehez ket elet..." << endl;
	B.pushBack(e7);
	B.pushBack(e8);
	cout << "P.length() == " << P.length() << endl;
	check(P.length() == 2);
      
	cout << "Es commitolunk...\n";
	B.commit();
      }
      cout << "P.length() == " << P.length() << endl;
      check(P.length() == 4);

#ifdef SKELETON
      cout << "P.head()==v3 ? " << (P.head()==v3) << endl;
      check(P.head() == v3);
#else
      cout << "P.head()==v3 ? " << (P.to()==v3) << endl;
      check(P.to() == v3);
#endif

      cout << "Vegigiteralunk az eleken." << endl;
      typedef DPath::NodeIt NodeIt;
      typedef DPath::EdgeIt EdgeIt;
      EdgeIt e;
      int i=1;
      for(P.first(e); e!=INVALID; ++e, ++i) {
	cout << i << ". el: " <</* e << */endl;
      }


      // Na ja, ez igy nem igazi, mindket esetet le kene tesztelni,
      // de legalabb valami:

#ifdef DEBUG
      rc = false;
      try {
	cout << "Setting an edgeiter to a nonexistant edge." << endl;
	//P.nth(e,134);
	rc = !debug;
      }
      catch(const Exception &e) {
	cout << "E: " << e.what() << endl;
	rc = debug;
      }
      check(rc);
#endif
    }

  }
  catch(const std::exception &e) {
    cout << "Uncaught exception: " << e.what() << endl;
    return 1;
  }
  catch(...) {
    cout << "Something horrible happened: an exception which isn't "
	 << "std::exception" << endl;
    return 2;
  }


  cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
       << endl;

  return passed ? 0 : 1;
}
