#include <iostream>
#include <lemon/list_graph.h>

using namespace lemon;

int main()
{
  typedef ListGraph Graph;
  typedef Graph::Edge Edge;
  typedef Graph::InEdgeIt InEdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;

  Graph g;
  
  for (int i = 0; i < 3; i++)
    g.addNode();
  
  for (NodeIt i(g); i!=INVALID; ++i)
    for (NodeIt j(g); j!=INVALID; ++j)
      if (i != j) g.addEdge(i, j);

  std::cout << "Nodes:";
  for (NodeIt i(g); i!=INVALID; ++i)
    std::cout << " " << g.id(i);
  std::cout << std::endl;

  std::cout << "Edges:";
  for (EdgeIt i(g); i!=INVALID; ++i)
    std::cout << " (" << g.id(g.source(i)) << "," << g.id(g.target(i)) << ")";
  std::cout << std::endl;
}
