// -*- c++ -*-
#include <iostream>
#include <fstream>

#include <sage_graph.h>
#include <lemon/smart_graph.h>
#include <lemon/dimacs.h>
#include <lemon/time_measure.h>
//#include <graph_wrapper.h>
#include <lemon/max_flow.h>
#include <augmenting_flow.h>
//#include <preflow_res.h>
#include <for_each_macros.h>
#include <lp_solver_wrapper.h>

using namespace lemon;

// Use a DIMACS max flow file as stdin.
// max_flow_demo < dimacs_max_flow_file

template<typename Edge, typename EdgeIndexMap> 
class PrimalMap {
protected:
  LPSolverWrapper* lp;
  EdgeIndexMap* edge_index_map;
public:
  PrimalMap(LPSolverWrapper& _lp, EdgeIndexMap& _edge_index_map) : 
    lp(&_lp), edge_index_map(&_edge_index_map) { }
  double operator[](Edge e) const { 
    return lp->getPrimal((*edge_index_map)[e]);
  }
};

int main(int, char **) {

  typedef SageGraph MutableGraph;
  //typedef SmartGraph Graph;
  typedef SageGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;

  Graph g;

  Node s, t;
  Graph::EdgeMap<int> cap(g);
  //readDimacsMaxFlow(std::cin, g, s, t, cap);
  readDimacs(std::cin, g, cap, s, t);
  Timer ts;
  Graph::EdgeMap<int> flow(g); //0 flow
  MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
    max_flow_test(g, s, t, cap, flow);
  AugmentingFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
    augmenting_flow_test(g, s, t, cap, flow);
  
  Graph::NodeMap<bool> cut(g);

  {
    std::cout << "preflow ..." << std::endl;
    ts.reset();
    max_flow_test.run();
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
    max_flow_test.actMinCut(cut);

    FOR_EACH_LOC(Graph::EdgeIt, e, g) {
      if (cut[g.source(e)] && !cut[g.target(e)] && !flow[e]==cap[e]) 
	std::cout << "Slackness does not hold!" << std::endl;
      if (!cut[g.source(e)] && cut[g.target(e)] && flow[e]>0) 
	std::cout << "Slackness does not hold!" << std::endl;
    }
  }

//   {
//     std::cout << "preflow ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     max_flow_test.preflow(MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> >::GEN_FLOW);
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;

//     FOR_EACH_LOC(Graph::EdgeIt, e, g) {
//       if (cut[g.source(e)] && !cut[g.target(e)] && !flow[e]==cap[e]) 
// 	std::cout << "Slackness does not hold!" << std::endl;
//       if (!cut[g.source(e)] && cut[g.target(e)] && flow[e]>0) 
// 	std::cout << "Slackness does not hold!" << std::endl;
//     }
//   }

//   {
//     std::cout << "wrapped preflow ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     pre_flow_res.run();
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "flow value: "<< pre_flow_test.flowValue() << std::endl;
//   }

  {
    std::cout << "physical blocking flow augmentation ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    int i=0;
    while (augmenting_flow_test.augmentOnBlockingFlow<MutableGraph>()) { ++i; }
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;

    FOR_EACH_LOC(Graph::EdgeIt, e, g) {
      if (cut[g.source(e)] && !cut[g.target(e)] && !flow[e]==cap[e]) 
	std::cout << "Slackness does not hold!" << std::endl;
      if (!cut[g.source(e)] && cut[g.target(e)] && flow[e]>0) 
	std::cout << "Slackness does not hold!" << std::endl;
    }
  }

//   {
//     std::cout << "faster physical blocking flow augmentation ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     int i=0;
//     while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) { ++i; }
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "number of augmentation phases: " << i << std::endl; 
//     std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
//   }

  {
    std::cout << "on-the-fly blocking flow augmentation ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    int i=0;
    while (augmenting_flow_test.augmentOnBlockingFlow2()) { ++i; }
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;

    FOR_EACH_LOC(Graph::EdgeIt, e, g) {
      if (cut[g.source(e)] && !cut[g.target(e)] && !flow[e]==cap[e]) 
	std::cout << "Slackness does not hold!" << std::endl;
      if (!cut[g.source(e)] && cut[g.target(e)] && flow[e]>0) 
	std::cout << "Slackness does not hold!" << std::endl;
    }
  }

//   {
//     std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     int i=0;
//     while (augmenting_flow_test.augmentOnShortestPath()) { ++i; }
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "number of augmentation phases: " << i << std::endl; 
//     std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;

//     FOR_EACH_LOC(Graph::EdgeIt, e, g) {
//       if (cut[g.source(e)] && !cut[g.target(e)] && !flow[e]==cap[e]) 
// 	std::cout << "Slackness does not hold!" << std::endl;
//       if (!cut[g.source(e)] && cut[g.target(e)] && flow[e]>0) 
// 	std::cout << "Slackness does not hold!" << std::endl;
//     }
//   }

//   {
//     std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     int i=0;
//     while (augmenting_flow_test.augmentOnShortestPath2()) { ++i; }
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "number of augmentation phases: " << i << std::endl; 
//     std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;

//     FOR_EACH_LOC(Graph::EdgeIt, e, g) {
//       if (cut[g.source(e)] && !cut[g.target(e)] && !flow[e]==cap[e]) 
// 	std::cout << "Slackness does not hold!" << std::endl;
//       if (!cut[g.source(e)] && cut[g.target(e)] && flow[e]>0) 
// 	std::cout << "Slackness does not hold!" << std::endl;
//     }
//   }

  ts.reset();
  LPSolverWrapper lp;
  lp.setMaximize();
  typedef LPSolverWrapper::ColIt ColIt;
  typedef LPSolverWrapper::RowIt RowIt;
  typedef Graph::EdgeMap<ColIt> EdgeIndexMap;
  EdgeIndexMap edge_index_map(g);
  PrimalMap<Graph::Edge, EdgeIndexMap> lp_flow(lp, edge_index_map);
  Graph::EdgeIt e;
  for (g.first(e); g.valid(e); g.next(e)) {
    ColIt col_it=lp.addCol();
    edge_index_map.set(e, col_it);
    lp.setColBounds(col_it, LPX_DB, 0.0, cap[e]);
  }
  Graph::NodeIt n;
  for (g.first(n); g.valid(n); g.next(n)) {
    if (n!=s) {
      //hurokelek miatt
      Graph::EdgeMap<int> coeffs(g, 0);
      {
	Graph::InEdgeIt e;
	for (g.first(e, n); g.valid(e); g.next(e)) coeffs.set(e, coeffs[e]+1);
      }
      {
	Graph::OutEdgeIt e;
	for (g.first(e, n); g.valid(e); g.next(e)) coeffs.set(e, coeffs[e]-1);
      }
      if (n==t) {
	Graph::EdgeIt e;
	//std::vector< std::pair<ColIt, double> > row;
	for (g.first(e); g.valid(e); g.next(e)) {
	  if (coeffs[e]!=0) 
	    lp.setObjCoef(edge_index_map[e], coeffs[e]);
	}
      } else  {
	RowIt row_it=lp.addRow();
	Graph::EdgeIt e;
	std::vector< std::pair<ColIt, double> > row;
	for (g.first(e); g.valid(e); g.next(e)) {
	  if (coeffs[e]!=0) 
	    row.push_back(std::make_pair(edge_index_map[e], coeffs[e]));
	}	
	lp.setRowCoeffs(row_it, row.begin(), row.end());
	lp.setRowBounds(row_it, LPX_FX, 0.0, 0.0);
      }
    }
  }
  lp.solveSimplex();
  std::cout << "flow value: "<< lp.getObjVal() << std::endl;
  std::cout << "elapsed time: " << ts << std::endl;

  return 0;
}
