// -*- c++ -*-
#ifndef DEFAULT_MAP_H
#define DEFAULT_MAP_H


#include <hugo/array_map.h>
#include <hugo/vector_map.h>

///\ingroup graphmaps
///\file
///\brief Graph maps that construates and destruates
///their elements dynamically.

namespace hugo {

/// \addtogroup graphmaps
/// @{

  /** The ArrayMap template class is graph map structure what
   *  automatically updates the map when a key is added to or erased from
   *  the map. This map uses the VectorMap if the ValueType is a primitive
   *  type and the ArrayMap for the other cases.
   *
   *  The template parameter is the MapRegistry that the maps
   *  will belong to and the ValueType.
   */


  /** Macro to implement the DefaultMap.
   */
#define DEFAULT_MAP_BODY(DynMap, Value) \
{ \
\
public: \
\
typedef DynMap<MapRegistry, Value> Parent; \
\
typedef typename MapRegistry::Graph Graph; \
\
DefaultMap() : Parent() {} \
DefaultMap(const Graph& g, MapRegistry& r) : Parent(g, r) {} \
DefaultMap(const Graph& g, MapRegistry& r, const Value& v) \
  : Parent(g, r, v) {} \
DefaultMap(const DefaultMap& copy) \
  : Parent(static_cast<const Parent&>(copy)) {} \
template <typename TT> \
DefaultMap(const DefaultMap<MapRegistry, TT>& copy) { \
  Parent::MapBase::operator= \
    (static_cast<const typename Parent::MapBase&>(copy)); \
  if (Parent::getGraph()) { \
    for (typename Parent::KeyIt it(*Parent::getGraph()); it!=INVALID; ++it) {\
      Parent::add(it); \
      Parent::operator[](it) = copy[it]; \
    } \
  } \
} \
DefaultMap& operator=(const DefaultMap& copy) { \
  Parent::operator=(static_cast<const Parent&>(copy)); \
  return *this; \
} \
template <typename TT> \
DefaultMap& operator=(const DefaultMap<MapRegistry, TT>& copy) { \
  Parent::clear(); \
  Parent::MapBase::operator=(copy); \
  if (Parent::getGraph()) { \
    for (typename Parent::KeyIt it(*Parent::getGraph()); it!=INVALID; ++it) {\
      Parent::add(it); \
      Parent::operator[](it) = copy[it]; \
    } \
  } \
  return *this; \
} \
};


  template <typename MapRegistry, typename Type>
  class DefaultMap : public ArrayMap<MapRegistry, Type> 
  DEFAULT_MAP_BODY(ArrayMap, Type);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, bool> 
    : public VectorMap<MapRegistry, bool> 
  DEFAULT_MAP_BODY(VectorMap, bool);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, char> 
    : public VectorMap<MapRegistry, char> 
  DEFAULT_MAP_BODY(VectorMap, char);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, int> 
    : public VectorMap<MapRegistry, int> 
  DEFAULT_MAP_BODY(VectorMap, int);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, short> 
    : public VectorMap<MapRegistry, short> 
  DEFAULT_MAP_BODY(VectorMap, short);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, long> 
    : public VectorMap<MapRegistry, long> 
  DEFAULT_MAP_BODY(VectorMap, long);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, float> 
    : public VectorMap<MapRegistry, float> 
  DEFAULT_MAP_BODY(VectorMap, float);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, double> 
    : public VectorMap<MapRegistry, double> 
  DEFAULT_MAP_BODY(VectorMap, double);

  template <typename MapRegistry>
  class DefaultMap<MapRegistry, long double> 
    : public VectorMap<MapRegistry, long double> 
  DEFAULT_MAP_BODY(VectorMap, long double);

  template <typename MapRegistry, typename Type>
  class DefaultMap<MapRegistry, Type*>
    : public VectorMap<MapRegistry, Type*> 
  DEFAULT_MAP_BODY(VectorMap, Type*);

}

#endif
