/* -*- C++ -*-
 * src/lemon/lp_glpk.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_LP_GLPK_CC
#define LEMON_LP_GLPK_CC

///\file
///\brief Implementation of the LEMON-GLPK lp solver interface.

#include "lp_glpk.h"

namespace lemon {

    /// \e
    int LpGlpk::_addCol() { 
	int i=lpx_add_cols(lp, 1);
	_setColLowerBound(i, -INF);
	_setColUpperBound(i, INF);
	return i;
    }

    /// \e
    int LpGlpk::_addRow() { 
	int i=lpx_add_rows(lp, 1);
	return i;
    }

  
    void LpGlpk::_setRowCoeffs(int i, 
			       int length,
			       const int   * indices, 
			       const Value   * values )
    {
      lpx_set_mat_row(lp, i, length,
		      const_cast<int * >(indices) ,
		      const_cast<Value * >(values));
    }
  
    void LpGlpk::_setColCoeffs(int i, 
			       int length,
			       const int   * indices, 
			       const Value   * values)
    {
      lpx_set_mat_col(lp, i, length,
		      const_cast<int * >(indices),
		      const_cast<Value * >(values));
    }
  
    void LpGlpk::_setColLowerBound(int i, Value lo)
    {
      if (lo==INF) {
	//FIXME error
      }
      int b=lpx_get_col_type(lp, i);
      double up=lpx_get_col_ub(lp, i);	
      if (lo==-INF) {
	switch (b) {
	case LPX_FR:
	case LPX_LO:
	  lpx_set_col_bnds(lp, i, LPX_FR, lo, up);
	  break;
	case LPX_UP:
	  break;
	case LPX_DB:
	case LPX_FX:
	  lpx_set_col_bnds(lp, i, LPX_UP, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      } else {
	switch (b) {
	case LPX_FR:
	case LPX_LO:
	  lpx_set_col_bnds(lp, i, LPX_LO, lo, up);
	  break;
	case LPX_UP:	  
	case LPX_DB:
	case LPX_FX:
	  if (lo==up) 
	    lpx_set_col_bnds(lp, i, LPX_FX, lo, up);
	  else 
	    lpx_set_col_bnds(lp, i, LPX_DB, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      }

    }
  
    void LpGlpk::_setColUpperBound(int i, Value up)
    {
      if (up==-INF) {
	//FIXME error
      }
      int b=lpx_get_col_type(lp, i);
      double lo=lpx_get_col_lb(lp, i);
      if (up==INF) {
	switch (b) {
	case LPX_FR:
	case LPX_LO:
	  break;
	case LPX_UP:
	  lpx_set_col_bnds(lp, i, LPX_FR, lo, up);
	  break;
	case LPX_DB:
	case LPX_FX:
	  lpx_set_col_bnds(lp, i, LPX_LO, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      } else {
	switch (b) {
	case LPX_FR:
	  lpx_set_col_bnds(lp, i, LPX_UP, lo, up);
	  break;
	case LPX_UP:
	  lpx_set_col_bnds(lp, i, LPX_UP, lo, up);
	  break;
	case LPX_LO:
	case LPX_DB:
	case LPX_FX:
	  if (lo==up) 
	    lpx_set_col_bnds(lp, i, LPX_FX, lo, up);
	  else 
	    lpx_set_col_bnds(lp, i, LPX_DB, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      }
    }
  
    void LpGlpk::_setRowLowerBound(int i, Value lo)
    {
      if (lo==INF) {
	//FIXME error
      }
      int b=lpx_get_row_type(lp, i);
      double up=lpx_get_row_ub(lp, i);	
      if (lo==-INF) {
	switch (b) {
	case LPX_FR:
	case LPX_LO:
	  lpx_set_row_bnds(lp, i, LPX_FR, lo, up);
	  break;
	case LPX_UP:
	  break;
	case LPX_DB:
	case LPX_FX:
	  lpx_set_row_bnds(lp, i, LPX_UP, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      } else {
	switch (b) {
	case LPX_FR:
	case LPX_LO:
	  lpx_set_row_bnds(lp, i, LPX_LO, lo, up);
	  break;
	case LPX_UP:	  
	case LPX_DB:
	case LPX_FX:
	  if (lo==up) 
	    lpx_set_row_bnds(lp, i, LPX_FX, lo, up);
	  else 
	    lpx_set_row_bnds(lp, i, LPX_DB, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      }
    }
  
    void LpGlpk::_setRowUpperBound(int i, Value up)
    {
      if (up==-INF) {
	//FIXME error
      }
      int b=lpx_get_row_type(lp, i);
      double lo=lpx_get_row_lb(lp, i);
      if (up==INF) {
	switch (b) {
	case LPX_FR:
	case LPX_LO:
	  break;
	case LPX_UP:
	  lpx_set_row_bnds(lp, i, LPX_FR, lo, up);
	  break;
	case LPX_DB:
	case LPX_FX:
	  lpx_set_row_bnds(lp, i, LPX_LO, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      } else {
	switch (b) {
	case LPX_FR:
	  lpx_set_row_bnds(lp, i, LPX_UP, lo, up);
	  break;
	case LPX_UP:
	  lpx_set_row_bnds(lp, i, LPX_UP, lo, up);
	  break;
	case LPX_LO:
	case LPX_DB:
	case LPX_FX:
	  if (lo==up) 
	    lpx_set_row_bnds(lp, i, LPX_FX, lo, up);
	  else 
	    lpx_set_row_bnds(lp, i, LPX_DB, lo, up);
	  break;
	default: ;
	  //FIXME error
	}
      }
    }
  
    void LpGlpk::_setObjCoeff(int i, Value obj_coef)
    {
      lpx_set_obj_coef(lp, i, obj_coef);
    }


  LpGlpk::SolutionStatus LpGlpk::_solve()
  {
    return SOLVED;
  }

  LpGlpk::Value LpGlpk::_getPrimal(int i)
  {
    return 0;
  }
  


} //END OF NAMESPACE LEMON

#endif //LEMON_LP_GLPK_CC
