/* -*- C++ -*-
 * src/lemon/lp_solver_skeleton.h
 * - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_LP_SOLVER_SKELETON
#define LEMON_LP_SOLVER_SKELETON

#include"lp_base.h"

///\file
///\brief A skeleton file to implement LP solver interfaces
namespace lemon {
  
  ///A skeleton class to implement LP solver interfaces
  class LpSolverSkeleton :public LpSolverBase {
    int col_num,row_num;
    
  protected:
    virtual int _addCol();
    virtual int _addRow();
    virtual void _setRowCoeffs(int i, 
			       int length,
                               int  const * indices, 
                               Value  const * values );
    virtual void _setColCoeffs(int i, 
			       int length,
                               int  const * indices, 
                               Value  const * values);
    virtual void _setColLowerBound(int i, Value value);
    virtual void _setColUpperBound(int i, Value value);
    virtual void _setRowLowerBound(int i, Value value);
    virtual void _setRowUpperBound(int i, Value value);
    virtual void _setObjCoeff(int i, Value obj_coef);
    virtual SolutionStatus _solve();
    virtual Value _getPrimal(int i);
  public:
    LpSolverSkeleton() : LpSolverBase(), col_num(0), row_num(0) {}
  };  

} //namespace lemon

#endif // LEMON_LP_SOLVER_SKELETON
