#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <dijkstra.h>
#include <time_measure.h>

#include <bin_heap.hh>
#include <fib_heap.h>

using namespace hugo;

int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachNodeIt EachNodeIt;
  typedef ListGraph::InEdgeIt InEdgeIt; 

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "dijkstra demo ..." << std::endl;
  
  double pre_time=currTime();
    Dijkstra<ListGraph, int, FibHeap<ListGraph::NodeIt, int, 
    ListGraph::NodeMap<int> > > dijkstra_test(G, s, cap);
    dijkstra_test.run();
  double post_time=currTime();
    
  std::cout << "running time with fib_heap: " 
	    << post_time-pre_time << " sec"<< std::endl; 
 
  pre_time=currTime();
  Dijkstra<ListGraph, int, BinHeap<ListGraph::NodeIt, int, 
    ListGraph::NodeMap<int> > > dijkstra_test2(G, s, cap);
  dijkstra_test2.run();
  post_time=currTime();
  
  std::cout << "running time with bin_heap: " 
	    << post_time-pre_time << " sec"<< std::endl; 
  

  int hiba_fib=0;
  int hiba_bin=0;
  EachNodeIt u;
  for ( G.getFirst(u) ; G.valid(u); G.next(u) ) {
    InEdgeIt e;
    for ( G.getFirst(e,u); G.valid(e); G.next(e) ) {
      NodeIt v=G.tail(e);
      if ( dijkstra_test.dist(u) - dijkstra_test.dist(v) > cap.get(e) )
	{
	  std::cout<<"Hibas el a fibonaccis Dijkstraban: " 
		   << dijkstra_test.dist(u) - dijkstra_test.dist(v) - 
	    cap.get(e)<<std::endl;
	  ++hiba_fib;
	}
      if ( dijkstra_test2.dist(u) - dijkstra_test2.dist(v) > cap.get(e) )
	{
	  std::cout<<"Hibas el a binarisos Dijkstraban: " 
		   << dijkstra_test2.dist(u) - dijkstra_test2.dist(v) - 
	    cap.get(e)<<std::endl;
	  ++hiba_bin;
	}
      if ( e==dijkstra_test.pred(u) && 
	   dijkstra_test.dist(u) - dijkstra_test.dist(v) != cap.get(e) )
	{
	  std::cout<<"Hibas fael a fibonaccis Dijkstraban!"<<std::endl;
	  ++hiba_fib;
	}
      if ( e==dijkstra_test2.pred(u) && 
	   dijkstra_test2.dist(u) - dijkstra_test2.dist(v) != cap.get(e) )
	{
	  std::cout<<"Hibas fael a binarisos Dijkstraban!"<<std::endl;
	  ++hiba_bin;
	}
    }
  }

  std::cout << "Hibas elek szama a fibonaccis Dijkstraban: " 
	    << hiba_fib << " a " << G.edgeNum() <<"-bol."<< std::endl;

  std::cout << "Hibas elek szama a binarisos Dijkstraban: " 
	    << hiba_bin << " a " << G.edgeNum() <<"-bol."<< std::endl;

  return 0;
}
