#include <iostream>
#include <fstream>

#include <list_graph.h>
#include <dimacs.h>
#include <prim.h>
#include <time_measure.h>

#include <bin_heap.hh>
#include <fib_heap.h>

using namespace hugo;

int main(int, char **) {
  typedef ListGraph::Node Node;

  ListGraph G;
  Node s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "prim demo ..." << std::endl;
  
  double pre_time=currTime();
    Prim<ListGraph, int, FibHeap<ListGraph::Node, int, 
    ListGraph::NodeMap<int> > > prim_test(G, cap);
    prim_test.run();
  double post_time=currTime();
    
  std::cout << "running time with fib_heap: " 
	    << post_time-pre_time << " sec"<< std::endl; 
 
  pre_time=currTime();
  Prim<ListGraph, int, BinHeap<ListGraph::Node, int, 
    ListGraph::NodeMap<int> > > prim_test2(G, cap);
  prim_test2.run();
  post_time=currTime();
  
  std::cout << "running time with bin_heap: " 
	    << post_time-pre_time << " sec"<< std::endl; 
  
  std::cout<<"A minimalis feszitofa sulya fib kupaccal: "<< prim_test.weight() <<std::endl;
  std::cout<<"A minimalis feszitofa sulya bin kupaccal: "<< prim_test2.weight() <<std::endl;
  if ( prim_test.weight() != prim_test2.weight() ) 
    std::cout<<"Nem egyezik meg!"<<std::endl; 
  else std::cout<<"Megegyezik."<<std::endl; 

  return 0;
}
