// -*- c++ -*-
#ifndef LEMON_LP_BASE_H
#define LEMON_LP_BASE_H

///\file
///\brief The interface of the LP solver interface.
namespace lemon {
  class LpSolverBase {
  protected:

    //MATRIX MANIPULATING FUNCTIONS

    /// \e
    virtual int _addCol() = 0;
    /// \e
    virtual int _addRow() = 0;
    /// \e
    /// \warning Arrays are indexed from 1 (datum at index 0 is ignored)
    virtual void _setRowCoeffs(int i, 
                               int  * &indices, 
                               double  * &doubles ) = 0;
    /// \e
    /// \warning Arrays are indexed from 1 (datum at index 0 is ignored)
    virtual void _setColCoeffs(int i, 
                               int  * &indices, 
                               double  * &doubles ) = 0;
    
  }  

} //namespace lemon

#endif //LEMON_LP_BASE_H
