SET(COIN_ROOT_DIR "" CACHE PATH "COIN root directory")

FIND_PATH(COIN_INCLUDE_DIR coin/CoinUtilsConfig.h
  PATHS ${COIN_ROOT_DIR}/include)

FIND_LIBRARY(COIN_CBC_LIBRARY libCbc
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_CBC_SOLVER_LIBRARY libCbcSolver
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_CGL_LIBRARY libCgl
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_CLP_LIBRARY libClp
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_COIN_UTILS_LIBRARY libCoinUtils
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_OSI_LIBRARY libOsi
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_OSI_CBC_LIBRARY libOsiCbc
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_OSI_CLP_LIBRARY libOsiClp
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_OSI_VOL_LIBRARY libOsiVol
  PATHS ${COIN_ROOT_DIR}/lib)
FIND_LIBRARY(COIN_VOL_LIBRARY libVol
  PATHS ${COIN_ROOT_DIR}/lib)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(COIN DEFAULT_MSG
  COIN_INCLUDE_DIR
  COIN_CBC_LIBRARY
  COIN_CBC_SOLVER_LIBRARY
  COIN_CGL_LIBRARY
  COIN_CLP_LIBRARY
  COIN_COIN_UTILS_LIBRARY
  COIN_OSI_LIBRARY
  COIN_OSI_CBC_LIBRARY
  COIN_OSI_CLP_LIBRARY
  COIN_OSI_VOL_LIBRARY
  COIN_VOL_LIBRARY
)

IF(COIN_FOUND)
  SET(COIN_INCLUDE_DIRS ${COIN_INCLUDE_DIR})
  SET(COIN_LIBRARIES "${COIN_CBC_LIBRARY};${COIN_CBC_SOLVER_LIBRARY};${COIN_CGL_LIBRARY};${COIN_CLP_LIBRARY};${COIN_COIN_UTILS_LIBRARY};${COIN_OSI_LIBRARY};${COIN_OSI_CBC_LIBRARY};${COIN_OSI_CLP_LIBRARY};${COIN_OSI_VOL_LIBRARY};${COIN_VOL_LIBRARY}")
  SET(COIN_CLP_LIBRARIES "${COIN_CLP_LIBRARY};${COIN_COIN_UTILS_LIBRARY}")
  SET(COIN_CBC_LIBRARIES ${COIN_LIBRARIES})
ENDIF(COIN_FOUND)

MARK_AS_ADVANCED(
  COIN_INCLUDE_DIR
  COIN_CBC_LIBRARY
  COIN_CBC_SOLVER_LIBRARY
  COIN_CGL_LIBRARY
  COIN_CLP_LIBRARY
  COIN_COIN_UTILS_LIBRARY
  COIN_OSI_LIBRARY
  COIN_OSI_CBC_LIBRARY
  COIN_OSI_CLP_LIBRARY
  COIN_OSI_VOL_LIBRARY
  COIN_VOL_LIBRARY
)

IF(COIN_FOUND)
  SET(LEMON_HAVE_LP TRUE)
  SET(LEMON_HAVE_MIP TRUE)
  SET(LEMON_HAVE_CLP TRUE)
  SET(LEMON_HAVE_CBC TRUE)
ENDIF(COIN_FOUND)
