// -*- c++ -*-
#include <iostream>
#include <fstream>

#include <LEDA/graph.h>
#include <leda_graph.h>
#include <dimacs.h>
#include <time_measure.h>
#include <edmonds_karp.h>

using namespace hugo;

using std::cout; 
using std::endl;

int main() {
  leda::graph g;
  typedef LedaGraph<leda::graph> Graph;
  Graph G(g);
//   G.addNode();
//   G.addNode();
//   std::cout << G.nodeNum() << std::endl; 

  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;  
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;
  typedef Graph::InEdgeIt InEdgeIt;

  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);


//   cout << "bfs and dfs iterator demo on the directed graph" << endl;
//   for(NodeIt n=G.first<NodeIt>(); G.valid(n); G.next(n)) { 
//     cout << G.id(n) << ": ";
//     cout << "out edges: ";
//     for(OutEdgeIt e=G.first<OutEdgeIt>(n); G.valid(e); G.next(e)) 
//       cout << G.id(G.tail(e)) << "-" << cap.get(e) << "->" << G.id(G.head(e)) << " ";
//     cout << "in edges: ";
//     for(InEdgeIt e=G.first<InEdgeIt>(n); G.valid(e); G.next(e)) 
//       cout << G.id(G.tail(e)) << "-" << cap.get(e) << "->" << G.id(G.head(e)) << " ";
//     cout << endl;
//   }

//   int i=0;
//   for(EdgeIt e=G.first<EdgeIt>(); G.valid(e); G.next(e)) { cap.set(e, i); i+=3; }
//   for(EdgeIt e=G.first<EdgeIt>(); G.valid(e); G.next(e)) { cout << cap.get(e) << " "; }
//   cout << endl;

  {
    //std::cout << "SmartGraph..." << std::endl;
    std::cout << "on-the-fly edmonds karp demo on wrapped leda graph..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow


    Timer ts;
    ts.reset();

    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > max_flow_test(G, s, t, flow, cap);
    //max_flow_test.augmentWithBlockingFlow<Graph>();
    int i=0;
    while (max_flow_test.augmentOnShortestPath()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
      ++i; 
    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }
  

  return 0;
}
