/* -*- C++ -*-
 * src/test/path_test.cc - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <string>
#include <iostream>
#include <lemon/concept/path.h>
#include <lemon/path.h>
#include <lemon/list_graph.h>

using namespace std;
using namespace lemon;
using namespace lemon::concept;

template<class Path> void checkCompilePath(Path &P) 
{
  typedef typename Path::EdgeIt EdgeIt;
  typedef typename Path::NodeIt NodeIt;
  typedef typename Path::GraphNode GraphNode;
  typedef typename Path::GraphEdge GraphEdge;
  //typedef typename Path::Builder Builder;
  //??? ha csinalok ilyet es siman Builderrel peldanyositok, akkor warningol. Talan friend miatt? De ki az?

  EdgeIt ei;
  NodeIt ni;
  GraphNode gn;
  GraphEdge ge;

  size_t st;
  bool b;

  //Path(const Graph &_G) {}      //the constructor has been already called

  st=P.length();                  //size_t length() const {return 0;}
  b=P.empty();                    //bool empty() const {}
  P.clear();                      //void clear() {}

  gn=P.target();                    //GraphNode/*It*/ target() const {return INVALID;}
  gn=P.source();                    //GraphNode/*It*/ source() const {return INVALID;}

  ei=P.first(ei);                 //It& first(It &i) const { return i=It(*this); }

  ni=P.target(ei);                  //NodeIt target(const EdgeIt& e) const {}
  ni=P.source(ei);                  //NodeIt source(const EdgeIt& e) const {}


  ListGraph lg;
  Path p(lg);

  EdgeIt i;	                  //EdgeIt() {}
  EdgeIt j(INVALID);	          //EdgeIt(Invalid) {}
  EdgeIt k(p);	                  //EdgeIt(const Path &_p) {}

  i=++j;	                  //EdgeIt& operator++() {}
  ++k;
  b=(i==j);	                  //bool operator==(const EdgeIt& e) const {return true;}
  b=(i!=j);	                  //bool operator!=(const EdgeIt& e) const {return true;}


  NodeIt l;                       //NodeIt() {}
  NodeIt m(INVALID);	          //NodeIt(Invalid) {}
  NodeIt n(p);	                  //NodeIt(const Path &_p) {}

  l=++m;                          //NodeIt& operator++() {}
  b=(m==n);                       //bool operator==(const NodeIt& e) const {}
  b=(m!=n);                   	  //bool operator!=(const NodeIt& e) const {}

  typename Path::Builder builder(p);     //Builder(Path &_P) : P(_P) {}
  builder.setStartNode(gn);     	 //void setStartNode(const GraphNode &) {}
  builder.pushFront(ge);	         //void pushFront(const GraphEdge& e) {}
  builder.pushBack(ge);	                 //void pushBack(const GraphEdge& e) {}
  builder.commit();	                 //void commit() {}
  builder.reserveFront(st);	         //void reserveFront(size_t r) {}
  builder.reserveBack(st);	         //void reserveBack(size_t r) {}

}

template void checkCompilePath< concept::Path<ListGraph> >(concept::Path<ListGraph> &);
template void checkCompilePath< DirPath<ListGraph> >(DirPath<ListGraph> &);
template void checkCompilePath< UndirPath<ListGraph> >(UndirPath<ListGraph> &);

int main() 
{
}
