// -*- c++ -*-
#ifndef HUGO_MAPSKELETON_H
#define HUGO_MAPSKELETON_H

namespace hugo {
  
  ///Readable map skeleton
  template<typename K, typename T>
  class ReadMapSkeleton
  {
  public:
    /// Map value type.
    typedef T ValueType;
    /// Map key type.
    typedef K KeyType;

    ///Default constructor.
    ReadMapSkeleton() {}
    
    ///Reads an element of the map.
    ValueType operator[](const KeyType &i) const {return ValueType();}
  };


  ///Writeable map skeleton
  template<typename K, typename T>
  class WriteMapSkeleton 
  {
  public:
    /// Map value type.
    typedef T ValueType;
    /// Map key type.
    typedef K KeyType;

    ///Default constructor.
    WriteMapSkeleton() {}
    ///'Fill with' constructor.
    WriteMapSkeleton(const ValueType &t) {}
    
    ///Write an element of a map.
    void set(const KeyType &i,const ValueType &t) {}
  };

  ///Read/Write map skeleton.
  template<typename K, typename T>
  class ReadWriteMapSkeleton : public ReadMapSkeleton<K,T>,
			       public WriteMapSkeleton<K,T>
  {
  public:
    ///Default constructor.
    ReadWriteMapSkeleton() : ReadMapSkeleton(), WriteMapSkeleton() {}
    ///'Fill with' constructor.
    ReadWriteMap(const ValueType &t) :ReadMapSkeleton(), WriteMapSkeleton(t) {}
  };
  
  
  ///Dereferable map skeleton
  template<typename K, typename T>
  class MemoryMapSkeleton : public ReadWriteMapSkeleton<K,T>
  {
  public:
    /// Map value type.
    typedef T ValueType;
    /// Map key type.
    typedef K KeyType;

    ///Default constructor.
    ReferenceMapSkeleton() : ReadWriteMapSkeleton() {}
    ///'Fill with' constructor.
    ReferenceMapSkeleton(const ValueType &t) : ReadWriteMapSkeleton(t) {}    

    ///Give a reference to the value belonging to a key.
    ValueType &operator[](const KeyType &i) {return *(ValueType*)0;} 
    ///Give a const reference to the value belonging to a key.
    const ValueType &operator[](const KeyType &i) const {return *(T*)0;}
  };



}
#endif // HUGO_MAPSKELETON_H
