// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>
#include <cstdlib>

#include <LEDA/graph.h>
#include <leda_graph_wrapper.h>
#include <dimacs.h>
#include <time_measure.h>
#include <edmonds_karp.h>

/**
 * Inicializalja a veletlenszamgeneratort.
 * Figyelem, ez nem jo igazi random szamokhoz,
 * erre ne bizzad a titkaidat!
 */
void random_init()
{
	unsigned int seed = getpid();
	seed |= seed << 15;
	seed ^= time(0);

	srand(seed);
}

/**
 * Egy veletlen int-et ad vissza 0 es m-1 kozott.
 */
int random(int m)
{
	return int( double(m) * rand() / (RAND_MAX + 1.0) );
}

using namespace hugo;

using std::cout; 
using std::endl;

int main() {
  leda::graph g;
  typedef LedaGraphWrapper<leda::graph> Graph;
  Graph G(g);

  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;  
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;
  typedef Graph::InEdgeIt InEdgeIt;

  //Node s, t;
  //Graph::EdgeMap<int> cap(G);
  //readDimacsMaxFlow(std::cin, G, s, t, cap);
  std::vector<Node> s_nodes;
  std::vector<Node> t_nodes;

  for(int i=0; i<20; ++i) {
    s_nodes.push_back(G.addNode());
  }
  for(int i=0; i<20; ++i) {
    t_nodes.push_back(G.addNode());
  }
  random_init();
  for(int i=0; i<50; ++i) {
    G.addEdge(s_nodes[random(20)], t_nodes[random(20)]);
  }
  Graph::NodeMap<bool> s_map(G); //false
  Graph::NodeMap<bool> t_map(G); //false
  
  for(int i=0; i<20; ++i) {
    s_map.set(s_nodes[i], true);
    t_map.set(t_nodes[i], true);
  }

  {
    std::cout << "on-the-fly max bipartite matching demo on wrapped leda graph..." << std::endl;
    Graph::EdgeMap<int> flow(G); //0 flow
    Graph::EdgeMap<int> cap(G, 1);

    Timer ts;
    ts.reset();

    MaxMatching<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > max_flow_test(G, s_map, t_map, flow, cap);
    //max_flow_test.augmentWithBlockingFlow<Graph>();
    int i=0;
    while (max_flow_test.augmentOnShortestPath()) { 
//     for(EdgeIt e=G.template first<EdgeIt>(); e.valid(); ++e) { 
//       std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//     }
//     std::cout<<std::endl;
      ++i; 
    }

//   std::cout << "maximum flow: "<< std::endl;
//   for(EdgeIt e=G.first<EdgeIt>(); e.valid(); ++e) { 
//     std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
//   }
//   std::cout<<std::endl;
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }
  

  return 0;
}
