#ifndef VECTOR_MAP_H
#define VECTOR_MAP_H

#include <vector>

#include "map_registry.h"

namespace hugo {
	
  template <typename MapRegistry>
  class VectorMapFactory {
  public:
		
    typedef typename MapRegistry::Graph Graph;
    typedef typename MapRegistry::Key Key;
    typedef typename MapRegistry::KeyIt KeyIt;

    typedef typename MapRegistry::MapBase MapBase;
		
    template <typename V> 
      class Map : public MapBase {
      public:
      typedef V Value;
	
      Map() {}
			
      Map(Graph& g, MapRegistry& r) : MapBase(g, r) {
	init();
      }
			
						
      virtual ~Map() {
	destroy();
      }
	
	
      Value& operator[](const Key& key) {
	int id = graph->id(key);
	return container[id];
      } 
		
      const Value& operator[](const Key& key) const {
	int id = graph->id(key);
	return container[id];
      }
	
      const Value& get(const Key& key) const {
	int id = graph->id(key);
	return container[id];
      } 
		
      void set(const Key& key, const Value& val) {
	int id = graph->id(key);
	container[id] = val;
      }
		
      void add(const Key& key) {
	int id = graph->id(key);
	if (id >= container.size()) {
	  container.resize(id + 1);
	}
      }
		
      void erase(const Key& key) {}
	
      private:
      typedef std::vector<Value> Container;
		
      Container container;
    };
		
  };
}

#endif
