#include <iostream>
#include <bin_heap.hh>
#include <string>
#include <map>

using namespace hugo;
using namespace std;

class string_int_map;

// Egy binaris kupac, ami stringekhez rendelt double ertekeket tarol,
// azaz mindig az a string van a tetejen, amihez a legkisebb szam tartozik.
// A kupac egy string_int_map tipusu property_map segitsegevel tarolja
// a stringek aktualis helyet sajatmagan belul.
// Egy olyan stringhez, ami meg nincsen a kupac -1 -et kell rendelnunk.
typedef BinHeap<string, double, string_int_map> StrDoubleHeap;

class string_int_map : public map<string,int> {
public:
  int get(const string &s) {
    // Bocs, ez igy gaaaany, de nem volt kedvem utananezni, hogy
    // hogy is mukodik ez a map :)
    if( count(s) == 0 ) {
      operator[](s) = StrDoubleHeap::PRE_HEAP;
    }
    return operator[](s);
  }
  void put(const string &s, int i) {
      operator[](s) = i;
  }
};


int main()
{
  string_int_map sim;
  
  
  cout << "testing string_int_map default value:\n";
  cout << "  alma: " << sim.get("alma") << endl;

  cout << "creating the heap\n";
  StrDoubleHeap heap(sim);

  cout << "heap.push(\"alma\", 15);\n";
  heap.push("alma", 15);

  cout << "heap.put(\"korte\", 3.4);\n";
  heap.put("korte", 3.4);

  cout << "heap.get(\"alma\") = " 
       << heap.get("alma")
       << endl;

  cout << "heap.top() = "
       << heap.top() << endl;
  cout << "heap.topValue() = "
       << heap.topValue() << endl;

  cout << "heap.decrease(\"alma\", 1.2);\n";
  heap.put("alma", 1.2);

  cout << "heap.top() = "
       << heap.top() << endl;
  cout << "heap.topValue() = "
       << heap.topValue() << endl;

  cout << "heap.put(\"alma\", 22);\n";
  heap.put("alma", 22);

  cout << "heap.top() = "
       << heap.top() << endl;
  cout << "heap.topValue() = "
       << heap.topValue() << endl;

  cout << "heap.size() = "
       << heap.size() << endl;
  cout << "heap.pop();\n";
  heap.pop();

  cout << "heap.top() = "
       << heap.top() << endl;
  cout << "heap.topValue() = "
       << heap.topValue() << endl;

  cout << "heap.state(\"szilva\") = "
       << heap.state("szilva") << endl;
  cout << "heap.put(\"szilva\", 0.5);\n";
  heap.put("szilva", 0.5);
  cout << "heap.state(\"szilva\") = "
       << heap.state("szilva") << endl;
  cout << "heap.top() = "
       << heap.top() << endl;
  cout << "heap.pop();\n";
  heap.pop();
  cout << "heap.state(\"szilva\") = "
       << heap.state("szilva") << endl;

  cout << "heap.size() = "
       << heap.size() << endl;
  cout << "heap.pop();\n";
  heap.pop();

  cout << "heap.size() = "
       << heap.size() << endl;  
  cout << "heap.empty() = "
       << (heap.empty()?"true":"false") << endl;  
}
