/*
reverse_bfs
by jacint
Performs a bfs on the out Edges. It does not count predecessors, 
only the distances, but one can easily modify it to know the pred as well.

Constructor: 

reverse_bfs(graph_type& G, NodeIt t)



Member functions:

void run(): runs a reverse bfs from t

  The following function should be used after run() was already run.

int dist(NodeIt v) : returns the distance from v to t. It is the number of Nodes if t is not reachable from v.

*/
#ifndef REVERSE_BFS_HH
#define REVERSE_BFS_HH

#include <queue>

#include <marci_graph_traits.hh>
#include <marciMap.hh>



namespace  marci {

  template <typename graph_type>
  class reverse_bfs {
    typedef typename graph_traits<graph_type>::NodeIt NodeIt;
    //typedef typename graph_traits<graph_type>::EdgeIt EdgeIt;
    typedef typename graph_traits<graph_type>::EachNodeIt EachNodeIt;
    typedef typename graph_traits<graph_type>::InEdgeIt InEdgeIt;


    graph_type& G;
    NodeIt t;
//    NodeMap<graph_type, EdgeIt> pred;
    NodeMap<graph_type, int> distance;
    

  public :

    /*
      The distance of the Nodes is n, except t for which it is 0.
    */
    reverse_bfs(graph_type& _G, NodeIt _t) : G(_G), t(_t), distance(G, number_of(G.first_Node())) {
      distance.put(t,0);
    }
    
    void run() {

      NodeMap<graph_type, bool> reached(G, false); 
      reached.put(t, true);

      std::queue<NodeIt> bfs_queue;
      bfs_queue.push(t);

      while (!bfs_queue.empty()) {

        NodeIt v=bfs_queue.front();	
	bfs_queue.pop();

	for(InEdgeIt e=G.template first<InEdgeIt>(v); e.valid(); ++e) {
	  NodeIt w=G.tail(e);
	  if (!reached.get(w)) {
	    bfs_queue.push(w);
	    distance.put(w, distance.get(v)+1);
	    reached.put(w, true);
	  }
	}
      }
    }



    int dist(NodeIt v) {
      return distance.get(v);
    }


  };

} // namespace hugo

#endif //REVERSE_BFS_HH


