/* -*- C++ -*-
 * src/lemon/lp_solver_skeleton.cc
 * - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include"lp_solver_skeleton.h"

///\file
///\brief A skeleton file to implement LP solver interfaces
namespace lemon {
  
  int LpSolverSkeleton::_addCol()
  {
    return 1;
  }
  
  int LpSolverSkeleton::_addRow() 
  {
    return 1;
  }
  
  void LpSolverSkeleton::_setRowCoeffs(int i, 
					       int length,
					       int  const * indices, 
					       Value  const * values )
  {
  }
  
  void LpSolverSkeleton::_setColCoeffs(int i, 
					       int length,
					       int  const * indices, 
					       Value  const * values)
  {
  }
  
  void LpSolverSkeleton::_setColLowerBound(int i, Value value)
  {
  }
  
  void LpSolverSkeleton::_setColUpperBound(int i, Value value)
  {
  }
  
  void LpSolverSkeleton::_setRowLowerBound(int i, Value value)
  {
  }
  
  void LpSolverSkeleton::_setRowUpperBound(int i, Value value)
  {
  }
  
  void LpSolverSkeleton::_setObjCoeff(int i, Value obj_coef)
  {
  }

  LpSolverSkeleton::SolutionType LpSolverSkeleton::_solve()
  {
    return OPTIMAL;
  }

  LpSolverSkeleton::Value LpSolverSkeleton::_getSolution(int i)
  {
    return 0;
  }
  
} //namespace lemon

