#include"lp_solver_skeleton.h"
#include"lp_glpk.h"

using namespace lemon;

void lpTest(LpSolverBase & lp)
{
  typedef LpSolverBase LP;

  std::vector<LP::Col> x;
  for(int i=0;i<10;i++) x.push_back(lp.addCol());

  std::vector<LP::Col> y(10);
  lp.addColSet(y);

  std::map<int,LP::Col> z;
  
  z.insert(std::make_pair(12,INVALID));
  z.insert(std::make_pair(2,INVALID));
  z.insert(std::make_pair(7,INVALID));
  z.insert(std::make_pair(5,INVALID));
  
  lp.addColSet(z);


  LP::Expr e;
  e[x[3]]=2;
  e[x[3]]=4;
  e[x[3]]=1;
  e.constComp()=12;

  LP::Col p1,p2,p3,p4,p5;
  
  lp.addRow(LP::INF,e,23);
  lp.addRow(LP::INF,3.0*(p1+p2)-p3,23);
  lp.addRow(LP::INF,3.0*(x[1]+x[2]/2)-x[3],23);
  lp.addRow(LP::INF,3.0*(p1+p2*2-5*p3+12-p4/3)+2*p4-4,23);
  lp.addRow(LP::INF,3.0*(x[1]+x[2]*2-5*x[3]+12-x[4]/3)+2*x[4]-4,23);
}


int main() 
{
  LpSolverSkeleton lp_skel;
  LpGlpk lp_glpk;

  lpTest(lp_skel);
  lpTest(lp_glpk);
}
