#include <iostream>

#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <merge_node_graph_wrapper.h>

using std::cout;
using std::endl;

using namespace lemon;

class Graph3 : ListGraph {
public:
  class Node : public ListGraph::Node { };
  class Edge { };
};

int main() {
  typedef SmartGraph Graph1;
  typedef ListGraph Graph2;
  Graph1 g;
  Graph2 h;
  typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
  GW gw(g, h);
  Graph1::Node n1=g.addNode();
  Graph1::Node n2=g.addNode();
  Graph1::Node n3=g.addNode();
  Graph2::Node n4=h.addNode();
  Graph2::Node n5=h.addNode();
  //GW::NodeIt n(gw)
  for (GW::NodeIt n(gw); n!=INVALID; ++n) { 
    cout << gw.id(n) << endl;
  }

  GW::NodeMap<int> nm(gw);
  int i=0;
  for (GW::NodeIt n(gw); n!=INVALID; ++n) { 
    ++i;
    nm.set(n, i);
  }
  for (Graph1::NodeIt n(g); n!=INVALID; ++n) { 
    cout << nm[n] << endl;
  }
  for (Graph2::NodeIt n(h); n!=INVALID; ++n) { 
    cout << nm[n] << endl;
  }

  gw.print();

  {
//    typedef SmartGraph Graph1;
    typedef ListGraph Graph1;
    typedef ListGraph Graph2;
    Graph1 g;
    Graph2 h;
    typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g, h);    
    gw.print();
  }
  {
//    typedef SmartGraph Graph1;
    typedef Graph3 Graph1;
    typedef ListGraph Graph2;
    Graph1 g;
    Graph2 h;
    typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g, h);    
    gw.print();
  }
  {
//    typedef SmartGraph Graph1;
    typedef ListGraph Graph1;
    typedef Graph3 Graph2;
    Graph1 g;
    Graph2 h;
    typedef MergeNodeGraphWrapper<Graph1, Graph2> GW;
    GW gw(g, h);    
    gw.print();
  }
}
