// -*- c++ -*-

// Use a DIMACS max flow file as follows:
// graph_wrapper_time dimacs_max_flow_file

#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <hugo/invalid.h>
#include <hugo/time_measure.h>
#include <hugo/graph_wrapper.h>
#include <hugo/max_flow.h>
#include <hugo/dimacs.h>
#include <hugo/list_graph.h>

using namespace hugo;

using std::cout;
using std::endl;

template<typename Graph>
void timeTest(std::string str, Graph& g) {
  g.clear();
  typename Graph::Node s;
  typename Graph::Node t;
  typedef typename Graph::template EdgeMap<int> FlowMap;
  FlowMap cap(g);
  FlowMap flow(g);
  std::ifstream is(str.c_str());
  readDimacs(is, g, cap, s, t);
  Timer ts;
  ts.reset();

  typedef MaxFlow<Graph, int, FlowMap, FlowMap> MyMaxFlow;
  MyMaxFlow max_flow(g, s, t, cap, flow);
  max_flow.run(MyMaxFlow::NO_FLOW);
  cout << ts << endl;
}

int main(int, char** argv) {
   std::string in=argv[1];

  typedef ListGraph Graph; 
  Graph g;
  timeTest<Graph>(in, g);
  typedef GraphWrapper<Graph> Graph1;
  Graph1 g1(g);
  timeTest<Graph1>(in, g1);
  typedef GraphWrapper<Graph1> Graph2;
  Graph2 g2(g1);
  timeTest<Graph2>(in, g2);
  typedef GraphWrapper<Graph2> Graph3;
  Graph3 g3(g2);
  timeTest<Graph3>(in, g3);
  typedef GraphWrapper<Graph3> Graph4;
  Graph4 g4(g3);
  timeTest<Graph4>(in, g4);
  typedef GraphWrapper<Graph4> Graph5;
  Graph5 g5(g4);
  timeTest<Graph5>(in, g5);
  typedef GraphWrapper<Graph5> Graph6;
  Graph6 g6(g5);
  timeTest<Graph6>(in, g6);  
  typedef GraphWrapper<Graph6> Graph7;
  Graph7 g7(g6);
  timeTest<Graph7>(in, g7);

  return 0;
}
