// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <string>

#include <sage_graph.h>
#include <hugo/list_graph.h>
#include <hugo/smart_graph.h>
#include <hugo/dimacs.h>
#include <hugo/max_flow.h>
#include <augmenting_flow.h>
#include <hugo/time_measure.h>
#include <for_each_macros.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo dimacs_max_flow_file

int main(int, char** argv) {

  std::string in=argv[1];
  typedef SageGraph MutableGraph;

  {
    typedef SageGraph Graph;
    typedef Graph::Node Node;
    typedef Graph::EdgeIt EdgeIt;

    Graph g;
    Node s, t;
    Graph::EdgeMap<int> cap(g);
    std::ifstream ins(in.c_str());
    //readDimacsMaxFlow(ins, g, s, t, cap);
    readDimacs(ins, g, cap, s, t);

    Timer ts;
    Graph::EdgeMap<int> flow(g); //0 flow
    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(g, s, t, cap, flow/*, true*/);
    AugmentingFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      augmenting_flow_test(g, s, t, cap, flow/*, true*/);

    std::cout << "SageGraph ..." << std::endl;

    {
      std::cout << "preflow ..." << std::endl;
      ts.reset();
      max_flow_test.run();
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
    }

    {
      std::cout << "physical blocking flow augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnBlockingFlow<MutableGraph>()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }

//     {
//       std::cout << "faster physical blocking flow augmentation ..." << std::endl;
//       FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//       ts.reset();
//       int i=0;
//       while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) { ++i; }
//       std::cout << "elapsed time: " << ts << std::endl;
//       std::cout << "number of augmentation phases: " << i << std::endl; 
//       std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
//     }

    {
      std::cout << "on-the-fly blocking flow augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnBlockingFlow2()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }

    {
      std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnShortestPath()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }
  }

  {
    typedef SmartGraph Graph;
    typedef Graph::Node Node;
    typedef Graph::EdgeIt EdgeIt;

    Graph g;
    Node s, t;
    Graph::EdgeMap<int> cap(g);
    std::ifstream ins(in.c_str());
    //readDimacsMaxFlow(ins, g, s, t, cap);
    readDimacs(ins, g, cap, s, t);

    Timer ts;
    Graph::EdgeMap<int> flow(g); //0 flow
    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(g, s, t, cap, flow/*, true*/);
    AugmentingFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      augmenting_flow_test(g, s, t, cap, flow/*, true*/);
    //    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
    //  max_flow_test(g, s, t, cap, flow);

    std::cout << "SmartGraph ..." << std::endl;

    {
      std::cout << "preflow ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      max_flow_test.run();
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
    }

    {
      std::cout << "physical blocking flow augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnBlockingFlow<MutableGraph>()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }

//     {
//       std::cout << "faster physical blocking flow augmentation ..." << std::endl;
//       FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//       ts.reset();
//       int i=0;
//       while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) { ++i; }
//       std::cout << "elapsed time: " << ts << std::endl;
//       std::cout << "number of augmentation phases: " << i << std::endl; 
//       std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
//     }

    {
      std::cout << "on-the-fly blocking flow augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnBlockingFlow2()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }

    {
      std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnShortestPath()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }
  }

  {
    typedef ListGraph Graph;
    typedef Graph::Node Node;
    typedef Graph::EdgeIt EdgeIt;

    Graph g;
    Node s, t;
    Graph::EdgeMap<int> cap(g);
    std::ifstream ins(in.c_str());
    //readDimacsMaxFlow(ins, g, s, t, cap);
    readDimacs(ins, g, cap, s, t);

    Timer ts;
    Graph::EdgeMap<int> flow(g); //0 flow
    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      max_flow_test(g, s, t, cap, flow/*, true*/);
    AugmentingFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
      augmenting_flow_test(g, s, t, cap, flow/*, true*/);
    //    MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
    //  max_flow_test(g, s, t, cap, flow);

    std::cout << "ListGraph ..." << std::endl;

    {
      std::cout << "preflow ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      max_flow_test.run();
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
    }

    {
      std::cout << "physical blocking flow augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnBlockingFlow<MutableGraph>()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }

//     {
//       std::cout << "faster physical blocking flow augmentation ..." << std::endl;
//       FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//       ts.reset();
//       int i=0;
//       while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) { ++i; }
//       std::cout << "elapsed time: " << ts << std::endl;
//       std::cout << "number of augmentation phases: " << i << std::endl; 
//       std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
//     }

    {
      std::cout << "on-the-fly blocking flow augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnBlockingFlow2()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }

    {
      std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
      for (Graph::EdgeIt e(g); e!=INVALID; ++e) flow.set(e, 0);
      ts.reset();
      int i=0;
      while (augmenting_flow_test.augmentOnShortestPath()) { ++i; }
      std::cout << "elapsed time: " << ts << std::endl;
      std::cout << "number of augmentation phases: " << i << std::endl; 
      std::cout << "flow value: "<< augmenting_flow_test.flowValue() << std::endl;
    }
  }

  return 0;
}
