#include <iostream>
#include <vector>
#include <string>

#include <list_graph.h>
#include <bfs_iterator.h>
#include <edmonds_karp.h>

using namespace hugo;

int main (int, char*[])
{
  typedef ListGraph::Node Node;
  typedef ListGraph::Edge Edge;
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EdgeIt EdgeIt;
  typedef ListGraph::OutEdgeIt OutEdgeIt;
  typedef ListGraph::InEdgeIt InEdgeIt;
  typedef ListGraph::SymEdgeIt SymEdgeIt;
  ListGraph G;
  std::vector<Node> vector_of_Nodes;
  for(int i=0; i!=8; ++i) vector_of_Nodes.push_back(G.addNode());
  for(int i=0; i!=8; ++i)
    for(int j=0; j!=8; ++j) 
      if ((i<j)&&(i+j)%3) G.addEdge(vector_of_Nodes[i], vector_of_Nodes[j]);

  std::cout << "We construct a directed graph on the node set {0,1,2,...,7}," <<std::endl << "i-->j is arc iff i<j and (i+j)%3." << std::endl;
  std::cout << "number of nodes: " << count(G.first<NodeIt>()) << std::endl;

  for(NodeIt i=G.first<NodeIt>(); G.valid(i); G.next(i)) {
    std::cout << "node " << G.id(i) << std::endl;
    std::cout << " outdegree (OutEdgeIt): " << count(G.first<OutEdgeIt>(i)) << " "; 
    for(OutEdgeIt j=G.first<OutEdgeIt>(i); G.valid(j); G.next(j)) { 
      std::cout << "(" << G.id(G.tail(j)) << "--" << G.id(j) << "->" << G.id(G.head(j)) << ") ";
    }
    std::cout << std::endl; 

    std::cout<< " ";
    for(OutEdgeIt j=G.first<OutEdgeIt>(i); G.valid(j); G.next(j)) { 
      std::cout << G.aNode(j) << "->" << G.bNode(j) << " "; } 
    std::cout<<std::endl;

    std::cout << " indegree: (InEdgeIt) " << count(G.first<InEdgeIt>(i)) << " ";
    for(InEdgeIt j=G.first<InEdgeIt>(i); G.valid(j); G.next(j)) { 
      std::cout << j << " "; } 
    std::cout << std::endl;

    std::cout<< " ";
    for(InEdgeIt j=G.first<InEdgeIt>(i); G.valid(j); G.next(j)) { 
      std::cout << G.aNode(j) << "->" << G.bNode(j) << " "; } 
    std::cout<<std::endl;

    std::cout << " degree: (SymEdgeIt) " << count(G.first<SymEdgeIt>(i)) << " ";
    for(SymEdgeIt j=G.first<SymEdgeIt>(i); G.valid(j); G.next(j)) { 
      std::cout << j << " "; } 
    std::cout<<std::endl;

    std::cout<< " ";
    for(SymEdgeIt j=G.first<SymEdgeIt>(i); G.valid(j); G.next(j)) { 
      std::cout << G.aNode(j) << "->" << G.bNode(j) << " "; } 
    std::cout<<std::endl;
  }

  std::cout << "all edges: ";
  for(EdgeIt i=G.first<EdgeIt>(); G.valid(i); G.next(i)) {
    std::cout << i << " ";
  }
  std::cout << std::endl;

  std::cout << "node property array test" << std::endl;
  ListGraph::NodeMap<int> my_property_vector(G);
  NodeIt v;
  G.first(v);
  my_property_vector.set(v, 42);
  my_property_vector.set(G.next(G.first<NodeIt>()), 314);
  my_property_vector.set(G.next(G.next(G.first<NodeIt>())), 1956);
  my_property_vector.set(vector_of_Nodes[3], 1989);
  my_property_vector.set(vector_of_Nodes[4], 2003);
  my_property_vector.set(vector_of_Nodes[7], 1978);
  std::cout << "some node property values..." << std::endl;
  for(NodeIt i=G.first<NodeIt>(); G.valid(i); G.next(i)) {
    std::cout << my_property_vector.get(i) << std::endl;
  }
  int _i=1;
  int _ii=1;
  ListGraph::EdgeMap<int> my_edge_property(G);
  for(EdgeIt i=G.first<EdgeIt>(); G.valid(i); G.next(i)) {
    my_edge_property.set(i, _i);
    _i*=_ii; ++_ii;
  }

  std::cout << "node and edge property values on the tails and heads of edges..." << std::endl;
  for(EdgeIt j=G.first<EdgeIt>(); G.valid(j); G.next(j)) {
    std::cout << my_property_vector.get(G.tail(j)) << "--" << my_edge_property.get(j) << "-->" << my_property_vector.get(G.head(j)) << " ";
  }
  std::cout << std::endl;
/*
  std::cout << "bfs from the first node" << std::endl;
  bfs<ListGraph> bfs_test(G, G.first<NodeIt>());
  bfs_test.run();
  std::cout << "reached: ";
  for(NodeIt i=G.first<NodeIt>(); G.valid(i); G.next(i)) {
    std::cout << bfs_test.reached.get(i) << " ";
  }
  std::cout<<std::endl;
  std::cout << "dist: ";
  for(NodeIt i=G.first<NodeIt>(); G.valid(i); G.next(i)) {
    std::cout << bfs_test.dist.get(i) << " ";
  }
  std::cout<<std::endl;
*/

  std::cout << "augmenting path flow algorithm test..." << std::endl;
  ListGraph flowG;

  Node s=flowG.addNode();
  Node v1=flowG.addNode();
  Node v2=flowG.addNode();
  Node v3=flowG.addNode();
  Node v4=flowG.addNode();
  Node t=flowG.addNode();
  
  ListGraph::NodeMap<std::string> node_name(flowG);
  node_name.set(s, "s");
  node_name.set(v1, "v1");
  node_name.set(v2, "v2");
  node_name.set(v3, "v3");
  node_name.set(v4, "v4");
  node_name.set(t, "t");

  Edge s_v1=flowG.addEdge(s, v1);
  Edge s_v2=flowG.addEdge(s, v2);
  Edge v1_v2=flowG.addEdge(v1, v2);
  Edge v2_v1=flowG.addEdge(v2, v1);
  Edge v1_v3=flowG.addEdge(v1, v3);
  Edge v3_v2=flowG.addEdge(v3, v2);
  Edge v2_v4=flowG.addEdge(v2, v4);
  Edge v4_v3=flowG.addEdge(v4, v3);
  Edge v3_t=flowG.addEdge(v3, t);
  Edge v4_t=flowG.addEdge(v4, t);

  ListGraph::EdgeMap<int> cap(flowG);

  cap.set(s_v1, 16);
  cap.set(s_v2, 13);
  cap.set(v1_v2, 10);
  cap.set(v2_v1, 4);
  cap.set(v1_v3, 12);
  cap.set(v3_v2, 9);
  cap.set(v2_v4, 14);
  cap.set(v4_v3, 7);
  cap.set(v3_t, 20);
  cap.set(v4_t, 4);

  std::cout << "on directed graph graph" << std::endl; //<< flowG;
  std::cout << "names and capacity values" << std::endl; 
  for(NodeIt i=flowG.first<NodeIt>(); flowG.valid(i); flowG.next(i)) { 
    std::cout << node_name.get(i) << ": ";
    std::cout << "out edges: ";
    for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << "in edges: ";
    for(InEdgeIt j=flowG.first<InEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << std::endl;
  }

  //flowG.deleteEdge(s_v1);
  //flowG.deleteEdge(s_v2);
  //flowG.deleteEdge(v1_v2);
  //flowG.deleteEdge(v1_v3);
  

  //flowG.setTail(v3_t, v2);
  //flowG.setHead(v3_t, s);
/*
  for(NodeIt i=flowG.first<NodeIt>(); flowG.valid(i); flowG.next(i)) { 
    std::cout << node_name.get(i) << ": ";
    std::cout << "out edges: ";
    for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << "in edges: ";
    for(InEdgeIt j=flowG.first<InEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << std::endl;
  }
  
  for(EdgeIt e=flowG.first<EdgeIt>(); flowG.valid(e); flowG.next(e)) {
    std::cout << node_name.get(flowG.tail(e)) << "-"<< cap.get(e) << "->" << node_name.get(flowG.head(e)) << " ";
  }
*/
  /*
  while (flowG.valid(flowG.first<EdgeIt>())) {
    flowG.deleteEdge(flowG.first<EdgeIt>());
    for(NodeIt i=flowG.first<NodeIt>(); flowG.valid(i); flowG.next(i)) { 
      std::cout << node_name.get(i) << ": ";
      std::cout << "out edges: ";
      for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << "in edges: ";
      for(InEdgeIt j=flowG.first<InEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << std::endl;
    }
  }
  
  while (flowG.valid(flowG.first<NodeIt>())) {
    flowG.deleteNode(flowG.first<NodeIt>());
    for(NodeIt i=flowG.first<NodeIt>(); flowG.valid(i); flowG.next(i)) { 
      std::cout << node_name.get(i) << ": ";
      std::cout << "out edges: ";
      for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << "in edges: ";
      for(InEdgeIt j=flowG.first<InEdgeIt>(i); flowG.valid(j); flowG.next(j)) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << std::endl;
    }
  }
  */

  //std::cout << std::endl;


  {
    ListGraph::EdgeMap<int> flow(flowG, 0);
    MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(flowG, s, t, flow, cap);
    /*
    max_flow_test.augmentOnBlockingFlow<ListGraph>();
    for(EdgeIt e=flowG.template first<EdgeIt>(); flowG.valid(e); flowG.next(e)) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;
    max_flow_test.augmentOnBlockingFlow<ListGraph>();
    for(EdgeIt e=flowG.template first<EdgeIt>(); flowG.valid(e); flowG.next(e)) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;*/
    //max_flow_test.run();
    
    //std::cout << "maximum flow: "<< std::endl;
    while (max_flow_test.augmentOnShortestPath()) {
      for(EdgeIt e=flowG.template first<EdgeIt>(); flowG.valid(e); flowG.next(e)) { 
	std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
      }
      std::cout<<std::endl;
    }
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }
/*
  {
    std::list<Node> S;
    S.push_back(s); S.push_back(v3);
    std::list<Node> T;
    T.push_back(t);

    ListGraph::EdgeMap<int> flow(flowG, 0);
    MaxFlow2<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(flowG, S, T, flow, cap);
    max_flow_test.run();
    
    std::cout << "maximum flow: "<< std::endl;
    for(EdgeIt e=flowG.template first<EdgeIt>(); flowG.valid(e); flowG.next(e)) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }
*/
  return 0;
}
