#include <iostream>
#include <algorithm>
#include <iterator>
#include <functional>
#include <lemon/list_graph.h>
#include <lemon/map_iterator.h>
#include <lemon/graph_reader.h>
#include <lemon/maps.h>

using namespace std;
using namespace lemon;

template <typename F, typename G>
struct unary_compose {
  typedef typename G::argument_type argument_type;
  typedef typename F::result_type result_type;
  
  unary_compose(const F& _f, const G& _g) : f(_f), g(_g) {}

  result_type operator()(const argument_type& x) {
    return f(g(x));
  }

private:
  F f;
  G g;
};

template <typename F, typename G>
unary_compose<F, G> compose1(const F& f, const G& g) {
  return unary_compose<F, G>(f, g);
}




template <typename T>
struct Second {
  typedef T argument_type;
  typedef typename T::second_type result_type;

  typename T::second_type operator()(const T& t) const {
    return t.second;
  }
};

template <typename T>
struct First {
  typedef T argument_type;
  typedef typename T::first_type result_type;
  typename T::first_type operator()(const T& t) const {
    return t.first;
  }
};


int main() {

  typedef ListGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::EdgeMap<int> LengthMap;

  typedef IdMap<Graph, Edge> EdgeIdMap;

  Graph graph;
  LengthMap length(graph);

  readGraph(std::cin, graph, length);

  const LengthMap& constLength = length;

  copy(length.valueSet().begin(), length.valueSet().end(), 
       ostream_iterator<int>(cout, " "));
  cout << endl;


  copy(constLength.valueSet().begin(), constLength.valueSet().end(), 
       ostream_iterator<int>(cout, " "));
  cout << endl;


  transform(constLength.keySet().begin(), constLength.keySet().end(), 
	    ostream_iterator<int>(cout, " "), 
	    MapFunctor<EdgeIdMap>(EdgeIdMap(graph)));
  cout << endl;


  transform(constLength.mapSet().begin(), constLength.mapSet().end(), 
	    ostream_iterator<int>(cout, " "), 
	    Second<LengthMap::MapSet::Value>());
  cout << endl;

  transform(constLength.mapSet().begin(), constLength.mapSet().end(), 
	    ostream_iterator<int>(cout, " "), 
	    compose1(MapFunctor<EdgeIdMap>(EdgeIdMap(graph)), 
		     First<LengthMap::MapSet::Value>() ));
  cout << endl;

  transform(length.mapSet().begin(), length.mapSet().end(), 
	    ostream_iterator<int>(cout, " "), 
	    Second<LengthMap::MapSet::Value>());
  cout << endl;

  transform(length.mapSet().begin(), length.mapSet().end(), 
	    ostream_iterator<int>(cout, " "), 
	    compose1(MapFunctor<EdgeIdMap>(EdgeIdMap(graph)), 
		     First<LengthMap::MapSet::Value>() ));
  cout << endl;

  return 0;
}
