#include <iostream>

#include <hugo/error.h>
#include "test_tools.h"
using namespace hugo;
using std::cout;
using std::endl;

void faulty_fn() {
  fault("This is a fault message");
}

void exception_fn() {
  throw Exception("This is a fn throwing excpt with some args: ") 
    << 5 << ", " << 18;
}

void unfinished_fn() {
  FIXME("unfinished_fn() is unfinished!");
}


int main() {
  try {
    faulty_fn();
    check(false, "A faulty function did not fail.");
  }
  catch(const Exception &e) {
    cout << "Exeption = \"" << e.what() << "\" (Right behaviour)" << endl;
  }

  try {
    exception_fn();
    check(false, "The function did not throw Exception.");
  }
  catch(const Exception &e) {
    cout << "Exeption = \"" << e.what() << "\" (Right behaviour)" << endl;
  }

  try {
    unfinished_fn();
    check(false, "FIXME macro does not work.");
  }
  catch(const Exception &e) {
    cout << "Exeption = \"" << e.what() << "\" (Right behaviour)" << endl;
  }

  return 0;
}
