// -*-mode: c++; -*-

class Graph
{
public:
  class EdgeIt {};
  
  class InEdgeIt : public EdgeIt
  class OutEdgeIt : public EdgeIt {};
  class SymEdgeIt : public EdgeIt {};
  class EachEdgeIt : public EdgeIt {};

  class NodeIt {};
    
  NodeIt &getFirst(NodeIt &);
  InEdgeIt &getFirst(InEdgeIt &,const NodeIt &);
  OutEdgeIt &getFirst(OutEdgeIt &,const NodeIt &);
  SymEdgeIt &getFirst(SymEdgeIt &,const NodeIt &);
  EachEdgeIt &getFirst(EachEdgeIt &);

  NodeIt next(const NodeIt &);
  InEdgeIt next(const InEdgeIt &);
  OutEdgeIt next(const OutEdgeIt &);
  SymEdgeIt next(const SymEdgeIt &);
  EachEdgeIt next(const EachEdgeIt &);

  NodeIt &goNext(const NodeIt &);
  InEdgeIt &goNext(const InEdgeIt &);
  OutEdgeIt &goNext(const OutEdgeIt &);
  SymEdgeIt &goNext(const SymEdgeIt &);
  EachEdgeIt &goNext(const EachEdgeIt &);

  bool valid(const NodeIt &n);
  bool valid(const EdgeIt &n);

  void setInvalid(const NodeIt &n);
  void setInvalid(const EdgeIt &n);
  
  NodeIt addNode();
  EdgeIt addEdge(const NodeIt from,const NodeIt to);
    
  void delete(NodeIt n);
  void delete(EdgeIt e);

  void clean();

  template<class T> class NodeMap
  {
  public:
    typedef T value_type;
    void set(const NodeIt i, const T &t);
    T get(const NodeIt i) const;
    T &operator[](const NodeIt i);
      
    NodeMap(const Graph &G);
  };

  template<class T> class EdgeMap
  {
  public:
    typedef T value_type;
    void set(const EdgeIt i, const T &t);
    T get(const EdgeIt i) const;
    T &operator[](const EdgeIt i);
      
    EdgeMap(const Graph &G);
  };
};
