#include <iostream>

#include <maps.h>
#include <unionfind.h>

using namespace hugo;
using namespace std;

bool passed = true;

void check(bool rc) {
  passed = passed && rc;
  if(!rc) {
    cout << "Test failed!" << endl;
  }
}

template <typename T>
class BaseMap : public StdMap<int,T> {};

typedef UnionFindEnum<int, BaseMap> UFE;

void print(UFE const &ufe) {
  UFE::ClassIt cit;
  cout << "printing the classes of the structure:" << endl;
  int i = 1;
  for (ufe.first(cit); ufe.valid(cit); ufe.next(cit)) {
    cout << "  " << i << " (" << cit << "):" << flush;
    UFE::ItemIt iit;
    for (ufe.first(iit, cit); ufe.valid(iit); ufe.next(iit)) {
      cout << " " << iit << flush;
    }
    cout << endl;
    i++;
  }
  cout << "done" << endl;
}


int main() {
  UFE::MapType base;
  UFE U(base);

  print(U);

  cout << "Inserting 1..." << endl;
  U.insert(1);
  print(U);
  
  cout << "Inserting 2..." << endl;
  U.insert(2);
  print(U);
  
  cout << "Joining 1 and 2..." << endl;
  check(U.join(1,2));
  print(U);

  cout << "Inserting 3, 4, 5, 6, 7..." << endl;
  U.insert(3);
  U.insert(4);
  U.insert(5);
  U.insert(6);
  U.insert(7);
  print (U);

  cout << "Joining 1 - 4, 2 - 4 and 3 - 5 ..." << endl;
  check(U.join(1,4));
  check(!U.join(2,4));
  check(U.join(3,5));
  print(U);

  cout << "size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 3);
  cout << "size of the class of 5: " << U.size(5) << endl;
  check(U.size(5) == 2);
  cout << "size of the class of 6: " << U.size(6) << endl;
  check(U.size(6) == 1);

  cout <<"erase 1: " << endl;
  U.erase(1);
  print(U);

  cout <<"erase 1: " << endl;
  U.erase(1);
  print(U);

  cout <<"erase 6: " << endl;
  U.erase(6);
  print(U);

  cout << "split the class of 5: " << endl;
  U.split(5);
  print(U);

  cout << "Joining 3 - 4 and 2 - 4 ..." << endl;
  check(U.join(3,4));
  check(!U.join(2,4));
  print(U);

  cout << "eraseClass 4 ..." << endl;
  U.eraseClass(4);
  print(U);

  cout << "eraseClass 7 ..." << endl;
  U.eraseClass(7);
  print(U);

  cout << "done" << endl;

  cout << (passed ? "All tests passed." : "Some of the tests failed!!!")
       << endl;

  return passed ? 0 : 1;
}
