#include <lemon/list_graph.h>

using namespace lemon;

typedef ListGraph Graph;
typedef Graph::NodeIt NodeIt;
typedef Graph::EdgeIt EdgeIt;

class MyEntity {
public:
  Graph &g;
  Graph::NodeMap<bool> selected;
  int edges;
  int covered_edges;

  MyEntity(Graph &_g) : g(_g), selected(_g) {}
  MyEntity(MyEntity& e) : g(e.g), selected(e.g) {
    for (NodeIt n(g); n != INVALID; ++n) {
      selected[n] = e.selected[n];
    }
    edges = e.edges;
    covered_edges = e.covered_edges;
  }
  double getCost() {
    return (double) (edges - covered_edges);
  }
  void mutate() {
  
  }
  void revert() {
  
  }
};

int main() {
  Graph g;
  // beolvasas
  MyEntity ent(g);

  // kezdeti lefedes generalasa
  int nn = 0;
  for (NodeIt n(g); n != INVALID; ++n) {
    ent.selected[n] = false;
    nn++;
  }
  // k db random node kivalasztasa

  int i = 0, j = 0;
  for (EdgeIt e(g); e != INVALID; ++e) {
    i++;
    if ((ent.selected[g.source(e)]) || (ent.selected[g.target(e)])) {
      j++;
    }
  }
  ent.edges = i;
  ent.covered_edges = j;

}
