/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2008
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<stdlib.h>
#include<lemon/random.h>
#include<lemon/time_measure.h>

using namespace lemon;

void f_no() 
{
}

inline void f_noi() 
{
}

inline void f_i() 
{
  static int r;  
  r=5;
}

inline void f_l() 
{
  static long int r;
  r=5;
}

inline void f_d() 
{
  static double r;
  r=5;
}

inline void f_rand() 
{
  static int r;  
  r=rand();
}

inline void f_random() 
{
  static long int r;
  r=random();
}

inline void f_drand48() 
{
  static double r;
  r=drand48();
}

inline void f_rnd_d() 
{
  static double r;
  r=rnd();
}
inline void f_rnd_int1000() 
{
  static int r;
  r=rnd[1000];
}
inline void f_rnd_bool() 
{
  static bool r;
  r=rnd.boolean();
}

// inline void f_() 
// {
//   static double r;
//   r=;
// }

int main()
{
  TimeStamp full;
  TimeStamp t;
  unsigned int n;
  
  const double TEST_DURATION=10;

  t=runningTimeTest(f_no,2,&n,&full);

  t=runningTimeTest(f_no,TEST_DURATION,&n,&full); 
  std::cout << "EMPTY:         ";
  std::cout << t.userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_noi,TEST_DURATION,&n,&full);
  std::cout << "INLINED EMPTY: ";
  std::cout << t.userTime() << " (" << n << " tests)\n";
  
  TimeStamp ti=t=runningTimeTest(f_i,TEST_DURATION,&n,&full);
  std::cout << "INT COPY:      ";
  std::cout << t.userTime() << " (" << n << " tests)\n";
  
  TimeStamp tl=t=runningTimeTest(f_l,TEST_DURATION,&n,&full);
  std::cout << "LONG COPY:     ";
  std::cout << t.userTime() << " (" << n << " tests)\n";
  
  TimeStamp td=t=runningTimeTest(f_d,TEST_DURATION,&n,&full);
  std::cout << "DOUBLE COPY:   ";
  std::cout << t.userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_rand,TEST_DURATION,&n,&full);
  std::cout << "rand():        ";
  std::cout << (t-ti).userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_random,TEST_DURATION,&n,&full);
  std::cout << "random():      ";
  std::cout << (t-tl).userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_drand48,TEST_DURATION,&n,&full);
  std::cout << "drand48():     ";
  std::cout << (t-td).userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_rnd_d,TEST_DURATION,&n,&full);
  std::cout << "rnd():         ";
  std::cout << (t-td).userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_rnd_int1000,TEST_DURATION,&n,&full);
  std::cout << "rnd[1000]:     ";
  std::cout << (t-ti).userTime() << " (" << n << " tests)\n";
  
  t=runningTimeTest(f_rnd_bool,TEST_DURATION,&n,&full);
  std::cout << "rnd.boolean(): ";
  std::cout << (t-ti).userTime() << " (" << n << " tests)\n";
  
//   t=runningTimeTest(f_,TEST_DURATION,&n,&full);
//   std::cout << "\n";
//   std::cout << t << " (" << n << " tests)\n";
//   std::cout << "Total: " << full << "\n\n";
  
  return 0;
}
