#ifndef VECTOR_MAP_H
#define VECTOR_MAP_H

#include <vector>
#include <iostream>

#include "map_base.h"

namespace hugo {

	template <typename G, typename K, typename KIt, typename V> 
	class VectorMap : public MapBase<G, K, KIt> {
	public:
		typedef V ValueType;
	
		VectorMap() {}
		VectorMap(typename MapBase<G, K, KIt>::Registry& r) : MapBase<G, K, KIt>(r) {}
	
	
		ValueType& operator[](const K& key) {
			int id = registry->getGraph().id(key);
			return container[id];
		} 
	
		const ValueType& operator[](const K& key) const {
			int id = registry->getGraph().id(key);
			return container[id];
		}
	
		const ValueType& get(const K& key) const {
			int id = registry->getGraph().id(key);
			return container[id];
		} 
	
		void set(const K& key, const ValueType& val) {
			int id = registry->getGraph().id(key);
			container[id] = val;
		}
	
		void add(const K& key) {
			int id = registry->getGraph().id(key);
			std::cerr << id << std::endl;
			if (id >= container.size()) {
				container.resize(id + 1);
			}
		}
	
		void erase(const K& key) {}

	private:
		typedef std::vector<ValueType> Container;
	
		Container container;
	};

}

#endif
