#ifndef PAC_MAP_FACTORY_H
#define PAC_MAP_FACTORY_H

#include "map_base.h"

/**
	Converter class to use the standard template
	libary's pair associative containers as a graph map.
*/

namespace hugo {
	
	template <typename G, typename K, typename KIt, template <typename, typename> class PAC>
	class PacMapFactory {
	
	
	public:
		
		typedef G Graph;
		typedef K Key;
		typedef KIt KeyIt;
		
		template <typename V> 
		class Map : public MapBase<G, K, KIt> {
		public:
			typedef V Value;
	
			Map() {}
			
			Map(Graph& g, MapRegistry<G, K, KIt>& r) 
				: MapBase<G, K, KIt>(g, r) {
				init();
			}
				
			virtual ~Map() {
				destroy();
			}
	
	
			V& operator[](const K& key) {
				return container.find(key)->second;
			} 
		
			const V& operator[](const K& key) const {
				return container.find(key)->second;
			}
	
			const V& get(const K& key) const {
				return container.find(key)->second;
			} 
		
			void set(const K& key, const V& value) {
				container.find(key)->second = value;
			}
		
			void add(const K& key) {
				container.insert(key);
			}
		
			void erase(const K& key) {
				container.erase(key);
			}
	
		private:
			typedef PAC<K, V> Container;
		
			Container container;
		};
		
	};
}

#endif