#ifndef VECTOR_MAP_H
#define VECTOR_MAP_H

#include <vector>

#include "map_base.h"

namespace hugo {
	
	template <typename G, typename K, typename KIt>
	class VectorMapFactory {
	
	
	public:
		
		typedef G Graph;
		typedef K Key;
		typedef KIt KeyIt;
		
		template <typename V> 
		class Map : public MapBase<G, K, KIt> {
		public:
			typedef V Value;
	
			Map() {}
			
			Map(Graph& g, MapRegistry<G, K, KIt>& r) 
				: MapBase<G, K, KIt>(g, r) {
				init();
			}
				
			virtual ~Map() {
				destroy();
			}
	
	
			Value& operator[](const K& key) {
				int id = graph->id(key);
				return container[id];
			} 
		
			const Value& operator[](const K& key) const {
				int id = graph->id(key);
				return container[id];
			}
	
			const Value& get(const K& key) const {
				int id = graph->id(key);
				return container[id];
			} 
		
			void set(const K& key, const Value& val) {
				int id = graph->id(key);
				container[id] = val;
			}
		
			void add(const K& key) {
				int id = graph->id(key);
				if (id >= container.size()) {
					container.resize(id + 1);
				}
			}
		
			void erase(const K& key) {}
	
		private:
			typedef std::vector<Value> Container;
		
			Container container;
		};
		
	};
}

#endif
