#ifndef MAP_REGISTRY_H
#define MAP_REGISTRY_H

#include <vector>

using namespace std;


namespace hugo {
	template <typename G, typename K, typename KIt>
	class MapRegistry;
}

#include "map_base.h"

namespace hugo {

	template <typename G, typename K, typename KIt>
	class MapRegistry {
	public:
		typedef G Graph;
		typedef K Key;
		typedef KIt KeyIt;
	
		typedef MapBase<Graph, Key, KIt> Map;
		friend class Base;
	
	protected:
	
		typedef std::vector<Map*> Container; 
	  Container container;

		
	public:
	
		MapRegistry() {}
	
		MapRegistry(const MapRegistry&) {}
		
		MapRegistry& operator=(const MapRegistry&) {
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->destroy();
				(*it)->graph = 0;
				(*it)->registry = 0;
			}
		}
				
		~MapRegistry() {
			typename Container::iterator it;
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->destroy();
				(*it)->registry = 0;
				(*it)->graph = 0;
			}
		}
	
	
	public:
	
		void attach(Map& map) {
			if (map.registry) {
				map.registry->detach(map);
			}
			container.push_back(&map);
			map.registry = this;
			map.registry_index = container.size()-1;
		} 
	
		void detach(Map& map) {
			container.back()->registry_index = map.registry_index; 
			container[map.registry_index] = container.back();
			container.pop_back();
			map.registry = 0;
			map.graph = 0;
		}
	
		
		virtual void add(Key& key) {
			typename Container::iterator it;
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->add(key);
			}
		}	
		
		virtual void erase(Key& key) {
			typename Container::iterator it;
			for (it = container.begin(); it != container.end(); ++it) {
				(*it)->erase(key);
			}
		}

	};

}

#endif
