/* -*- C++ -*-
 * src/lemon/maps.h - Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2005 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef LEMON_LP_BASE_H
#define LEMON_LP_BASE_H

///\file
///\brief The interface of the LP solver interface.
namespace lemon {
  class LpSolverBase {
  public:

    //UNCATEGORIZED

    /// \e
    typedef double Value;
    /// \e 
    static const Value INF;
   protected:

    //MATRIX MANIPULATING FUNCTIONS

    /// \e
    virtual int _addCol() = 0;
    /// \e
    virtual int _addRow() = 0;
    /// \e
    /// \warning Arrays are indexed from 1 (datum at index 0 is ignored)
    virtual void _setRowCoeffs(int i, 
                               int  const * indices, 
                               Value  const * values ) = 0;
    /// \e
    /// \warning Arrays are indexed from 1 (datum at index 0 is ignored)
    virtual void _setColCoeffs(int i, 
                               int  const * indices, 
                               Value  const * values ) = 0;
    
    /// \e
    /// The lower bound of a variable (column) have to be given by an 
    /// extended number of type Value, i.e. a finite number of type 
    /// Value or -INF.
    virtual void _setColLowerBound(int i, Value value) = 0;
    /// \e
    /// The upper bound of a variable (column) have to be given by an 
    /// extended number of type Value, i.e. a finite number of type 
    /// Value or INF.
    virtual void _setColUpperBound(int i, Value value) = 0;
    /// \e
    /// The lower bound of a linear expression (row) have to be given by an 
    /// extended number of type Value, i.e. a finite number of type 
    /// Value or -INF.
    virtual void _setRowLowerBound(int i, Value value) = 0;
    /// \e
    /// The upper bound of a linear expression (row) have to be given by an 
    /// extended number of type Value, i.e. a finite number of type 
    /// Value or INF.
    virtual void _setRowUpperBound(int i, Value value) = 0;

    /// \e
    virtual void _setObjCoeff(int i, Value obj_coef) = 0;
  };  

} //namespace lemon

#endif //LEMON_LP_BASE_H
