// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>

#include <list_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <hugo/time_measure.h>
#include <hugo/for_each_macros.h>
#include <bfs_dfs.h>
#include <hugo/graph_wrapper.h>
#include <bipartite_graph_wrapper.h>
#include <hugo/maps.h>
#include <max_flow.h>

using namespace hugo;

int main() {
  typedef UndirListGraph Graph; 
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  Graph g;
//   std::vector<Graph::Node> s_nodes;
//   std::vector<Graph::Node> t_nodes;
//   for (int i=0; i<3; ++i) s_nodes.push_back(g.addNode());
//   for (int i=0; i<3; ++i) t_nodes.push_back(g.addNode());
//   g.addEdge(s_nodes[0], t_nodes[2]);
//   g.addEdge(t_nodes[1], s_nodes[2]);
//   g.addEdge(s_nodes[0], t_nodes[1]);
  
//   Graph::NodeMap<int> ref_map(g, -1);
//   IterableBoolMap< Graph::NodeMap<int> > bipartite_map(ref_map);
//   for (int i=0; i<3; ++i) bipartite_map.insert(s_nodes[i], false);
//   for (int i=0; i<3; ++i) bipartite_map.insert(t_nodes[i], true);

  std::vector<Graph::Node> nodes;
  for (int i=0; i<3; ++i) nodes.push_back(g.addNode());
  for (int i=3; i<6; ++i) nodes.push_back(g.addNode());
  g.addEdge(nodes[0], nodes[3+2]);
  g.addEdge(nodes[3+1], nodes[2]);
  g.addEdge(nodes[0], nodes[3+1]);
  
  Graph::NodeMap<int> ref_map(g, -1);
  IterableBoolMap< Graph::NodeMap<int> > bipartite_map(ref_map);
  for (int i=0; i<3; ++i) bipartite_map.insert(nodes[i], false);
  for (int i=3; i<6; ++i) bipartite_map.insert(nodes[i], true);

  Graph::Node u;
  std::cout << "These nodes will be in S:\n";
  //FIXME azert kellene ++, es invalid vizsgalat u-bol, hogy ezt le lehessen 
  //irni 1etlen FOR_EACH-csel.
  for (bipartite_map.first(u, false); g.valid(u); bipartite_map.next(u)) 
    std::cout << u << " ";
  std::cout << "\n";
  std::cout << "These nodes will be in T:\n";
  for (bipartite_map.first(u, true); g.valid(u); bipartite_map.next(u)) 
    std::cout << u << " ";
  std::cout << "\n";

  typedef BipartiteGraphWrapper<Graph> BGW;
  BGW bgw(g, bipartite_map);

  std::cout << "Nodes by NodeIt:\n";
  FOR_EACH_LOC(BGW::NodeIt, n, bgw) {
    std::cout << n << " ";
  }
  std::cout << "\n";
  std::cout << "Nodes in S by ClassNodeIt:\n";
  FOR_EACH_INC_LOC(BGW::ClassNodeIt, n, bgw, bgw.S_CLASS) {
    std::cout << n << " ";
  }
  std::cout << "\n";
  std::cout << "Nodes in T by ClassNodeIt:\n";
  FOR_EACH_INC_LOC(BGW::ClassNodeIt, n, bgw, bgw.T_CLASS) {
    std::cout << n << " ";
  }
  std::cout << "\n";
  std::cout << "Edges of the bipartite graph:\n";
  FOR_EACH_LOC(BGW::EdgeIt, e, bgw) {
    std::cout << bgw.tail(e) << "->" << bgw.head(e) << std::endl;
  }

  BGW::NodeMap<int> dbyj(bgw);
  BGW::EdgeMap<int> dbyxcj(bgw);

  typedef stGraphWrapper<BGW> stGW;
  stGW stgw(bgw);
  ConstMap<stGW::Edge, int> const1map(1);
  stGW::NodeMap<int> ize(stgw);
  stGW::EdgeMap<int> flow(stgw);

  BfsIterator< BGW, BGW::NodeMap<bool> > bfs(bgw);
  Graph::NodeIt si;
  Graph::Node s; 
  s=g.first(si);
  bfs.pushAndSetReached(BGW::Node(s));
  while (!bfs.finished()) { ++bfs; }

  FOR_EACH_LOC(stGW::NodeIt, n, stgw) { 
    std::cout << "out-edges of " << n << ":\n"; 
    FOR_EACH_INC_LOC(stGW::OutEdgeIt, e, stgw, n) { 
      std::cout << " " << e << "\n";
      std::cout << " aNode: " << stgw.aNode(e) << "\n";
      std::cout << " bNode: " << stgw.bNode(e) << "\n";      
    }
    std::cout << "in-edges of " << n << ":\n"; 
    FOR_EACH_INC_LOC(stGW::InEdgeIt, e, stgw, n) { 
      std::cout << " " << e << "\n";
      std::cout << " aNode: " << stgw.aNode(e) << "\n";
      std::cout << " bNode: " << stgw.bNode(e) << "\n";     
    }
  }
  std::cout << "Edges of the stGraphWrapper:\n"; 
  FOR_EACH_LOC(stGW::EdgeIt, n, stgw) { 
    std::cout << " " << n << "\n";
  }

  stGW::NodeMap<bool> b(stgw);
  FOR_EACH_LOC(stGW::NodeIt, n, stgw) { 
    std::cout << n << ": " << b[n] <<"\n";
  }

  std::cout << "Bfs from s: \n";
  BfsIterator< stGW, stGW::NodeMap<bool> > bfs_stgw(stgw);
  bfs_stgw.pushAndSetReached(stgw.S_NODE);
  while (!bfs_stgw.finished()) { 
    std::cout << " " << stGW::OutEdgeIt(bfs_stgw) << "\n";
    ++bfs_stgw; 
  }
  
  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow);
  while (max_flow_test.augmentOnShortestPath()) { }

  std::cout << max_flow_test.flowValue() << std::endl;

  return 0;
}
