// -*- c++ -*-
#include <iostream>
#include <fstream>

#include <list_graph.h>
#include <hugo/smart_graph.h>
#include <hugo/dimacs.h>
#include <hugo/time_measure.h>
//#include <graph_wrapper.h>
#include <max_flow.h>
//#include <preflow_res.h>
#include <hugo/for_each_macros.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file


//   struct Ize {
//   };
  
//   struct Mize {
//     Ize bumm;
//   };

//   template <typename B>
//     class Huha {
//     public:
//       int u;
//       B brr;
//     };


int main(int, char **) {

  typedef ListGraph MutableGraph;

  typedef SmartGraph Graph;
  //  typedef ListGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;


//   Mize mize[10];
//   Mize bize[0];
//   Mize zize;
//   typedef Mize Tize[0];

//   std::cout << &zize << " " << sizeof(mize) << sizeof(Tize) << std::endl;
//   std::cout << sizeof(bize) << std::endl;


//   Huha<Tize> k;
//   std::cout << sizeof(k) << std::endl;


//   struct Bumm {
//     //int a;
//     bool b;
//   };

//   std::cout << sizeof(Bumm) << std::endl;


  Graph g;
  Node s, t;
  Graph::EdgeMap<int> cap(g);
  //readDimacsMaxFlow(std::cin, g, s, t, cap);
  readDimacs(std::cin, g, cap, s, t);
  Timer ts;
  Graph::EdgeMap<int> flow(g); //0 flow
  MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
    max_flow_test(g, s, t, cap, flow);

  {
    std::cout << "preflow ..." << std::endl;
    ts.reset();
    max_flow_test.run();
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "preflow ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    max_flow_test.preflow(MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> >::GEN_FLOW);
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

//   {
//     std::cout << "wrapped preflow ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     pre_flow_res.run();
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "flow value: "<< pre_flow_test.flowValue() << std::endl;
//   }

  {
    std::cout << "physical blocking flow augmentation ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    int i=0;
    while (max_flow_test.augmentOnBlockingFlow<MutableGraph>()) { ++i; }
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

//   {
//     std::cout << "faster physical blocking flow augmentation ..." << std::endl;
//     FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
//     ts.reset();
//     int i=0;
//     while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) { ++i; }
//     std::cout << "elapsed time: " << ts << std::endl;
//     std::cout << "number of augmentation phases: " << i << std::endl; 
//     std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
//   }

  {
    std::cout << "on-the-fly blocking flow augmentation ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    int i=0;
    while (max_flow_test.augmentOnBlockingFlow2()) { ++i; }
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "on-the-fly shortest path augmentation ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    int i=0;
    while (max_flow_test.augmentOnShortestPath()) { ++i; }
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "number of augmentation phases: " << i << std::endl; 
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }


  return 0;
}
