#include <iostream>
#include <smart_graph.h>

using namespace hugo;

template<class GG,class TT>
class CinCoutMap
{
public:
  typedef GG Graph;
  typedef typename GG::Edge Edge;
  
  typedef Edge KeyType;
  typedef TT ValueType;
  
  class RefType 
  {
    Graph &G;
    Edge e;
  public:
    RefType(Graph &_G,Edge _e) : G(_G), e(_e) { }
    
    operator ValueType() const 
    {
      ValueType tmp;
      std::cout << G.id(G.tail(e)) << "->"
		<< G.id(G.head(e)) << ": ";
      std::cin  >> tmp;
      return tmp;
    }
    ValueType operator = (ValueType v) const
    {
      std::cout << G.id(G.tail(e)) << "->"
		<< G.id(G.head(e)) << ": " << v << '\n';
      return v;
    }
  };
  
private:
  Graph &G;
public:
  CinCoutMap(Graph &_G) : G(_G) { }
  RefType operator[] (Edge e) const { return RefType(G,e);}  
};

int main()
{
  typedef SmartGraph Graph;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;
  typedef Graph::EdgeIt EdgeIt;
  
  Graph G;

  CinCoutMap<Graph,int> map(G);

  Graph::EdgeMap<int> emap(G);
  
  for(int i=0;i<3;i++) G.addNode();

  for(NodeIt n(G);G.valid(n);G.next(n))
    for(NodeIt m(G);G.valid(m);G.next(m)) if(n!=m)
      G.addEdge(n,m);

  //for(OutEdgeIt e(G,NodeIt(G));G.valid(e);G.next(e))
    
  for(EdgeIt e(G);G.valid(e);G.next(e)) emap[e] = map[e];
  
  std::cout << '\n';
  
  for(EdgeIt e(G);G.valid(e);G.next(e))  map[e] = emap[e];

}

