// -*- c++ -*-
#ifndef HUGO_SKELETON_GRAPH_H
#define HUGO_SKELETON_GRAPH_H

///\ingroup skeletons
///\file
///\brief Declaration of GraphSkeleton.

#include <hugo/invalid.h>
#include <hugo/skeletons/maps.h>

/// The namespace of HugoLib
namespace hugo {
  namespace skeleton {
    
    /// \addtogroup skeletons
    /// @{

    /// An empty static graph class.
  
    /// This class provides all the common features of a graph structure,
    /// however completely without implementations and real data structures
    /// behind the interface.
    /// All graph algorithms should compile with this class, but it will not
    /// run properly, of course.
    ///
    /// It can be used for checking the interface compatibility,
    /// or it can serve as a skeleton of a new graph structure.
    /// 
    /// Also, you will find here the full documentation of a certain graph
    /// feature, the documentation of a real graph imlementation
    /// like @ref ListGraph or
    /// @ref SmartGraph will just refer to this structure.
    class StaticGraphSkeleton
    {
    public:
      /// Defalult constructor.
      StaticGraphSkeleton() { }
      ///Copy consructor.

      ///\todo It is not clear, what we expect from a copy constructor.
      ///E.g. How to assign the nodes/edges to each other? What about maps?
      StaticGraphSkeleton(const StaticGraphSkeleton& g) { }

      /// The base type of node iterators, 
      /// or in other words, the trivial node iterator.

      /// This is the base type of each node iterator,
      /// thus each kind of node iterator converts to this.
      /// More precisely each kind of node iterator have to be inherited 
      /// from the trivial node iterator.
      class Node {
      public:
	/// @warning The default constructor sets the iterator
	/// to an undefined value.
	Node() { }
	/// Copy constructor.
	Node(const Node&) { }
	/// Invalid constructor \& conversion.

	/// This constructor initializes the iterator to be invalid.
	/// \sa Invalid for more details.
	Node(Invalid) { }
	/// Two iterators are equal if and only if they point to the
	/// same object or both are invalid.
	bool operator==(Node) const { return true; }

	/// \sa \ref operator==(Node n)
	///
	bool operator!=(Node) const { return true; }

	bool operator<(Node) const { return true; }
      };
    
      /// This iterator goes through each node.

      /// This iterator goes through each node.
      /// Its usage is quite simple, for example you can count the number
      /// of nodes in graph \c g of type \c Graph like this:
      /// \code
      /// int count=0;
      /// for (Graph::NodeIt n(g); g.valid(n); ++n) ++count;
      /// \endcode
      class NodeIt : public Node {
      public:
	/// @warning The default constructor sets the iterator
	/// to an undefined value.
	NodeIt() { }
	/// Copy constructor.
	NodeIt(const NodeIt&) { }
	/// Invalid constructor \& conversion.

	/// Initialize the iterator to be invalid.
	/// \sa Invalid for more details.
	NodeIt(Invalid) { }
	/// Sets the iterator to the first node of \c g.
	NodeIt(const StaticGraphSkeleton& g) { }
	/// Sets the iterator to the node of \c g pointed by the trivial 
	/// iterator n. This feature necessitates that each time we 
	/// iterate the node-set, the iteration order is the same.
	NodeIt(const StaticGraphSkeleton& g, const Node& n) { }
	/// Assign the iterator to the next node.
	NodeIt& operator++() { return *this; }
      };
    
    
      /// The base type of the edge iterators.
      class Edge {
      public:
	/// @warning The default constructor sets the iterator
	/// to an undefined value.
	Edge() { }
	/// Copy constructor.
	Edge(const Edge&) { }
	/// Initialize the iterator to be invalid.
	Edge(Invalid) { }
	/// Two iterators are equal if and only if they point to the
	/// same object or both are invalid.
	bool operator==(Edge) const { return true; }
	bool operator!=(Edge) const { return true; }
	bool operator<(Edge) const { return true; }
      };
    
      /// This iterator goes trough the outgoing edges of a node.

      /// This iterator goes trough the \e outgoing edges of a certain node
      /// of a graph.
      /// Its usage is quite simple, for example you can count the number
      /// of outgoing edges of a node \c n
      /// in graph \c g of type \c Graph as follows.
      /// \code
      /// int count=0;
      /// for (Graph::OutEdgeIt e(g, n); g.valid(e); ++e) ++count;
      /// \endcode
    
      class OutEdgeIt : public Edge {
      public:
	/// @warning The default constructor sets the iterator
	/// to an undefined value.
	OutEdgeIt() { }
	/// Copy constructor.
	OutEdgeIt(const OutEdgeIt&) { }
	/// Initialize the iterator to be invalid.
	OutEdgeIt(Invalid) { }
	/// This constructor sets the iterator to first outgoing edge.
    
	/// This constructor set the iterator to the first outgoing edge of
	/// node
	///@param n the node
	///@param g the graph
	OutEdgeIt(const StaticGraphSkeleton& g, const Node& n) { }
	/// Sets the iterator to the value of the trivial iterator \c e.
	/// This feature necessitates that each time we 
	/// iterate the edge-set, the iteration order is the same.
	OutEdgeIt(const StaticGraphSkeleton& g, const Edge& e) { }
	/// Assign the iterator to the next outedge of the corresponding node.
	OutEdgeIt& operator++() { return *this; }
      };

      /// This iterator goes trough the incoming edges of a node.

      /// This iterator goes trough the \e incoming edges of a certain node
      /// of a graph.
      /// Its usage is quite simple, for example you can count the number
      /// of outgoing edges of a node \c n
      /// in graph \c g of type \c Graph as follows.
      /// \code
      /// int count=0;
      /// for(Graph::InEdgeIt e(g, n); g.valid(e); ++) ++count;
      /// \endcode

      class InEdgeIt : public Edge {
      public:
	/// @warning The default constructor sets the iterator
	/// to an undefined value.
	InEdgeIt() { }
	/// Copy constructor.
	InEdgeIt(const InEdgeIt&) { }
	/// Initialize the iterator to be invalid.
	InEdgeIt(Invalid) { }
	/// .
	InEdgeIt(const StaticGraphSkeleton&, const Node&) { }
	/// .
	InEdgeIt(const StaticGraphSkeleton&, const Edge&) { }
	/// Assign the iterator to the next inedge of the corresponding node.
	InEdgeIt& operator++() { return *this; }
      };
      //  class SymEdgeIt : public Edge {};

      /// This iterator goes through each edge.

      /// This iterator goes through each edge of a graph.
      /// Its usage is quite simple, for example you can count the number
      /// of edges in a graph \c g of type \c Graph as follows:
      /// \code
      /// int count=0;
      /// for(Graph::EdgeIt e(g); g.valid(e); ++e) ++count;
      /// \endcode
      class EdgeIt : public Edge {
      public:
	/// @warning The default constructor sets the iterator
	/// to an undefined value.
	EdgeIt() { }
	/// Copy constructor.
	EdgeIt(const EdgeIt&) { }
	/// Initialize the iterator to be invalid.
	EdgeIt(Invalid) { }
	/// .
	EdgeIt(const StaticGraphSkeleton&) { }
	/// .
	EdgeIt(const StaticGraphSkeleton&, const Edge&) { } 
	EdgeIt& operator++() { return *this; }
      };

      /// First node of the graph.

      /// \retval i the first node.
      /// \return the first node.
      ///
      NodeIt& first(NodeIt& i) const { return i; }

      /// The first incoming edge.
      InEdgeIt& first(InEdgeIt &i, Node) const { return i; }
      /// The first outgoing edge.
      OutEdgeIt& first(OutEdgeIt& i, Node) const { return i; }
      //  SymEdgeIt& first(SymEdgeIt&, Node) const { return i; }
      /// The first edge of the Graph.
      EdgeIt& first(EdgeIt& i) const { return i; }

      //     Node getNext(Node) const {}
      //     InEdgeIt getNext(InEdgeIt) const {}
      //     OutEdgeIt getNext(OutEdgeIt) const {}
      //     //SymEdgeIt getNext(SymEdgeIt) const {}
      //     EdgeIt getNext(EdgeIt) const {}

      /// Go to the next node.
      NodeIt& next(NodeIt& i) const { return i; }
      /// Go to the next incoming edge.
      InEdgeIt& next(InEdgeIt& i) const { return i; }
      /// Go to the next outgoing edge.
      OutEdgeIt& next(OutEdgeIt& i) const { return i; }
      //SymEdgeIt& next(SymEdgeIt&) const { }
      /// Go to the next edge.
      EdgeIt& next(EdgeIt& i) const { return i; }

      ///Gives back the head node of an edge.
      Node head(Edge) const { return INVALID; }
      ///Gives back the tail node of an edge.
      Node tail(Edge) const { return INVALID; }
  
      //   Node aNode(InEdgeIt) const {}
      //   Node aNode(OutEdgeIt) const {}
      //   Node aNode(SymEdgeIt) const {}

      //   Node bNode(InEdgeIt) const {}
      //   Node bNode(OutEdgeIt) const {}
      //   Node bNode(SymEdgeIt) const {}

      /// Checks if a node iterator is valid

      ///\todo Maybe, it would be better if iterator converted to
      ///bool directly, as Jacint prefers.
      bool valid(const Node&) const { return true; }
      /// Checks if an edge iterator is valid

      ///\todo Maybe, it would be better if iterator converted to
      ///bool directly, as Jacint prefers.
      bool valid(const Edge&) const { return true; }

      ///Gives back the \e id of a node.

      ///\warning Not all graph structures provide this feature.
      ///
      int id(const Node&) const { return 0; }
      ///Gives back the \e id of an edge.

      ///\warning Not all graph structures provide this feature.
      ///
      int id(const Edge&) const { return 0; }

      /// Resets the graph.

      /// This function deletes all edges and nodes of the graph.
      /// It also frees the memory allocated to store them.
      void clear() { }

      int nodeNum() const { return 0; }
      int edgeNum() const { return 0; }


      ///Reference map of the nodes to type \c T.

      ///Reference map of the nodes to type \c T.
      /// \sa ReferenceSkeleton
      /// \warning Making maps that can handle bool type (NodeMap<bool>)
      /// needs extra attention!

      template<class T> class NodeMap
	: public ReferenceMap< Node, T >
      {
      public:

	NodeMap(const StaticGraphSkeleton&) { }
	NodeMap(const StaticGraphSkeleton&, T) { }

	///Copy constructor
	template<typename TT> NodeMap(const NodeMap<TT>&) { }
	///Assignment operator
	template<typename TT> NodeMap& operator=(const NodeMap<TT>&)
	{ return *this; }
      };

      ///Reference map of the edges to type \c T.

      ///Reference map of the edges to type \c T.
      /// \sa ReferenceSkeleton
      /// \warning Making maps that can handle bool type (EdgeMap<bool>)
      /// needs extra attention!
      template<class T> class EdgeMap
	: public ReferenceMap<Edge,T>
      {
      public:
	typedef T ValueType;
	typedef Edge KeyType;

	EdgeMap(const StaticGraphSkeleton&) { }
	EdgeMap(const StaticGraphSkeleton&, T) { }
    
	///Copy constructor
	template<typename TT> EdgeMap(const EdgeMap<TT>&) { }
	///Assignment operator
	template<typename TT> EdgeMap &operator=(const EdgeMap<TT>&)
	{ return *this; }
      };
    };


  
    /// An empty graph class.

    /// This class provides everything that \c StaticGraphSkeleton
    /// with additional functionality which enables to build a
    /// graph from scratch.
    class GraphSkeleton : public StaticGraphSkeleton
    {
    public:
      /// Defalult constructor.
      GraphSkeleton() { }
      ///Copy consructor.

      ///\todo It is not clear, what we expect from a copy constructor.
      ///E.g. How to assign the nodes/edges to each other? What about maps?
      GraphSkeleton(const GraphSkeleton&) { }

      ///Add a new node to the graph.

      /// \return the new node.
      ///
      Node addNode() { return INVALID; }
      ///Add a new edge to the graph.

      ///Add a new edge to the graph with tail node \c tail
      ///and head node \c head.
      ///\return the new edge.
      Edge addEdge(Node, Node) { return INVALID; }
    
      /// Resets the graph.

      /// This function deletes all edges and nodes of the graph.
      /// It also frees the memory allocated to store them.
      /// \todo It might belong to \c EraseableGraphSkeleton.
      void clear() { }
    };

    /// An empty eraseable graph class.
  
    /// This class is an extension of \c GraphSkeleton. It also makes it
    /// possible to erase edges or nodes.
    class EraseableGraphSkeleton : public GraphSkeleton
    {
    public:
      /// Deletes a node.
      void erase(Node n) { }
      /// Deletes an edge.
      void erase(Edge e) { }

      /// Defalult constructor.
      EraseableGraphSkeleton() { }
      ///Copy consructor.
      EraseableGraphSkeleton(const GraphSkeleton&) { }
    };

    // @}
  } //namespace skeleton
  
} //namespace hugo



// class EmptyBipGraph : public Graph Skeleton
// {
//   class ANode {};
//   class BNode {};

//   ANode &next(ANode &) {}
//   BNode &next(BNode &) {}

//   ANode &getFirst(ANode &) const {}
//   BNode &getFirst(BNode &) const {}

//   enum NodeClass { A = 0, B = 1 };
//   NodeClass getClass(Node n) {}

// }

#endif // HUGO_SKELETON_GRAPH_H
