#include "test_tools.h"
#include <hugo/smart_graph.h>
#include <hugo/dijkstra.h>

using namespace hugo;

const int PET_SIZE =5;


void check_Dijkstra_SmartGraph_BinHeap_Compile() 
{
  typedef int VType;
  typedef SmartGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::EdgeMap<VType> LengthMap;
 
  typedef Dijkstra<Graph, LengthMap> DType;
  
  Graph G;
  Node n;
  Edge e;
  VType l;
  bool b;
  DType::DistMap d(G);
  DType::PredMap p(G);
  DType::PredNodeMap pn(G);
  LengthMap cap(G);

  DType dijkstra_test(G,cap);

  dijkstra_test.run(n);

  l  = dijkstra_test.dist(n);
  e  = dijkstra_test.pred(n);
  n  = dijkstra_test.predNode(n);
  d  = dijkstra_test.distMap();
  p  = dijkstra_test.predMap();
  pn = dijkstra_test.predNodeMap();
  b  = dijkstra_test.reached(n);

}

int main()
{
    
  typedef SmartGraph Graph;

  typedef Graph::Edge Edge;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::EdgeMap<int> LengthMap;

  Graph G;
  Node s, t;
  LengthMap cap(G);
  PetStruct<Graph> ps = addPetersen(G,PET_SIZE);
   
  for(int i=0;i<PET_SIZE;i++) {
    cap[ps.outcir[i]]=4;
    cap[ps.incir[i]]=1;
    cap[ps.chords[i]]=10;
  }
  s=ps.outer[0];
  t=ps.inner[1];
  
  Dijkstra<Graph, LengthMap> 
	dijkstra_test(G, cap);
  dijkstra_test.run(s);
  
  check(dijkstra_test.dist(t)==13,"Dijkstra found a wrong path.");


  for(EdgeIt e(G); e==INVALID; ++e) {
    Node u=G.tail(e);
    Node v=G.head(e);
    check( !dijkstra_test.reached(u) ||
	   (dijkstra_test.dist(v) - dijkstra_test.dist(u) <= cap[e]),
	   "dist(head)-dist(tail)- edge_length= " 
	   << dijkstra_test.dist(v) - dijkstra_test.dist(u) 
	   - cap[e]);
  }

  ///\bug This works only for integer lengths
  for(NodeIt v(G); v==INVALID; ++v)
    if ( dijkstra_test.reached(v) ) {
      Edge e=dijkstra_test.pred(v);
      Node u=G.tail(e);
      check(dijkstra_test.dist(v) - dijkstra_test.dist(u) == cap[e],
	    "Bad shortest path tree edge! Difference: " 
	    << std::abs(dijkstra_test.dist(v) - dijkstra_test.dist(u) 
			    - cap[e]));
    }
}
