#ifndef HUGO_TEST_TEST_TOOLS_H
#define HUGO_TEST_TEST_TOOLS_H

//! \ingroup misc
//! \file
//! \brief Some utility to write test programs.


#include<iostream>
#include<vector>

///If \c rc is fail, writes an error message end exit.

///If \c rc is fail, writes an error message end exit.
///The error message contains the file name and the line number of the
///source code in a standard from, which makes it possible to go there
///using good source browsers like e.g. \c emacs.
///
///For example
///\code check(0==1,"This is obviously false.");\endcode will
///print this (and then exits).
///\verbatim graph_test.cc:123: error: This is obviously false. \endverbatim
///
///\todo It should be in \c error.h
#define check(rc, msg) \
  if(!(rc)) { \
    std::cerr << __FILE__ ":" << __LINE__ << ": error: " << msg << std::endl; \
    exit(1); \
  } else { } \

///Structure returned by \ref addPetersen().

///Structure returned by \ref addPetersen().
///
template<class Graph> struct PetStruct
{
  ///.
  std::vector<typename Graph::Node> outer, inner;
  ///.
  std::vector<typename Graph::Edge> outcir, incir, chords;
};



///Adds a Petersen graph to \c G.

///Adds a Petersen graph to \c G.
///The nodes end edges will be listed in the return structure.

template<typename Graph>
PetStruct<Graph> addPetersen(Graph &G,int num=5)
{
  PetStruct<Graph> n;

  for(int i=0;i<num;i++) {
    n.outer.push_back(G.addNode());
    n.inner.push_back(G.addNode());
  }

 for(int i=0;i<num;i++) {
   n.chords.push_back(G.addEdge(n.outer[i],n.inner[i]));
   n.outcir.push_back(G.addEdge(n.outer[i],n.outer[(i+1)%5]));
   n.incir.push_back(G.addEdge(n.inner[i],n.inner[(i+2)%5]));
  }
 return n;
}



#endif
